/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals.switchcombat;

import com.infamous.dungeons_mobs.interfaces.IShieldUser;
import com.infamous.dungeons_mobs.tags.CustomTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraftforge.common.ToolActions;

public class ShieldAndMeleeAttackGoal<T extends PathfinderMob>
extends MeleeAttackGoal {
    private final T hostCreature;
    private final int maxCloseQuartersShieldUseTime;
    private final int attackWindowTime;
    private int seeTime;
    private int closeQuartersShieldUseCounter;
    private final double closeQuartersRangeSq;

    public ShieldAndMeleeAttackGoal(T creatureEntity, double speedTowardsTarget, boolean useLongMemory, double closeQuartersRange, int maxCloseQuartersShieldUseTime, int attackWindowTime) {
        super(creatureEntity, speedTowardsTarget, useLongMemory);
        this.hostCreature = creatureEntity;
        this.closeQuartersRangeSq = closeQuartersRange * closeQuartersRange;
        this.maxCloseQuartersShieldUseTime = maxCloseQuartersShieldUseTime;
        this.attackWindowTime = attackWindowTime;
        this.closeQuartersShieldUseCounter = 0;
    }

    private boolean hasShieldInOffhand() {
        return this.hostCreature.m_21206_().canPerformAction(ToolActions.SHIELD_BLOCK);
    }

    private void useShield() {
        if (this.hasShieldInOffhand() && !((IShieldUser)this.hostCreature).isShieldDisabled()) {
            this.hostCreature.m_6672_(InteractionHand.OFF_HAND);
        }
    }

    private void stopUsingShield() {
        if (this.hostCreature.m_21254_()) {
            this.hostCreature.m_21253_();
        }
    }

    public boolean m_8036_() {
        if (this.hasShieldInOffhand() && !((IShieldUser)this.hostCreature).isShieldDisabled()) {
            LivingEntity attackTarget = this.hostCreature.m_5448_();
            return attackTarget != null && attackTarget.m_6084_();
        }
        return super.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
    }

    public boolean m_8045_() {
        if (this.hasShieldInOffhand() && !((IShieldUser)this.hostCreature).isShieldDisabled()) {
            return this.m_8036_();
        }
        return super.m_8045_();
    }

    public void m_8041_() {
        if (this.hasShieldInOffhand() && this.hostCreature.m_21254_()) {
            this.seeTime = 0;
            this.closeQuartersShieldUseCounter = 0;
            this.stopUsingShield();
        }
        super.m_8041_();
    }

    public void m_8037_() {
        LivingEntity attackTarget = this.hostCreature.m_5448_();
        boolean dontShieldAgainst = attackTarget != null && attackTarget.m_6095_().m_204039_(CustomTags.DONT_SHIELD_AGAINST);
        boolean shieldDisabled = ((IShieldUser)this.hostCreature).isShieldDisabled();
        boolean hasShield = this.hasShieldInOffhand();
        if (hasShield && !shieldDisabled && attackTarget != null && !dontShieldAgainst) {
            boolean closeQuarters;
            double hostDistanceSq = this.hostCreature.m_20275_(attackTarget.m_20185_(), attackTarget.m_20186_(), attackTarget.m_20189_());
            double detectRange = this.hostCreature.m_21133_(Attributes.f_22277_);
            double detectRangeSq = detectRange * detectRange;
            boolean canSee = this.hostCreature.m_21574_().m_148306_((Entity)attackTarget);
            this.seeTime = canSee ? ++this.seeTime : 0;
            if (hostDistanceSq <= detectRangeSq && this.seeTime >= 5) {
                this.hostCreature.m_21573_().m_26573_();
            }
            boolean bl = closeQuarters = hostDistanceSq <= this.closeQuartersRangeSq;
            if (closeQuarters && this.hostCreature.m_21254_()) {
                ++this.closeQuartersShieldUseCounter;
            }
            if (this.closeQuartersShieldUseCounter >= this.maxCloseQuartersShieldUseTime) {
                this.closeQuartersShieldUseCounter = 0;
                this.stopUsingShield();
                ((IShieldUser)this.hostCreature).setShieldCooldownTime(this.attackWindowTime);
                return;
            }
            this.hostCreature.m_21563_().m_24960_((Entity)attackTarget, 30.0f, 30.0f);
            if (!canSee) {
                this.stopUsingShield();
                return;
            }
            if (!this.hostCreature.m_21254_()) {
                this.useShield();
            }
        } else if (attackTarget != null) {
            this.closeQuartersShieldUseCounter = 0;
            super.m_8037_();
        }
    }
}

