/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals.switchcombat;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SnowballItem;

public class SwitchCombatItemGoal
extends Goal {
    private final Mob hostMob;
    private LivingEntity target;
    private final double minDistance;
    private final double maxDistance;

    public SwitchCombatItemGoal(Mob mobEntity, double minDistance, double maxDistance) {
        this.hostMob = mobEntity;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    private boolean hasRangedItemInMainhand() {
        return this.hostMob.m_21205_().m_41720_() instanceof ProjectileWeaponItem || this.hostMob.m_21205_().m_41720_() instanceof SnowballItem || this.hostMob.m_21205_().m_41720_() instanceof EggItem;
    }

    private boolean hasRangedItemInOffhand() {
        return this.hostMob.m_21206_().m_41720_() instanceof ProjectileWeaponItem || this.hostMob.m_21206_().m_41720_() instanceof SnowballItem || this.hostMob.m_21205_().m_41720_() instanceof EggItem;
    }

    private void swapWeapons() {
        ItemStack mainhand = this.hostMob.m_21205_();
        ItemStack offhand = this.hostMob.m_21206_();
        this.hostMob.m_8061_(EquipmentSlot.OFFHAND, mainhand);
        this.hostMob.m_8061_(EquipmentSlot.MAINHAND, offhand);
    }

    public boolean m_8036_() {
        this.target = this.hostMob.m_5448_();
        if (this.target == null) {
            return false;
        }
        if (!this.target.m_6084_()) {
            return false;
        }
        return ((double)this.hostMob.m_20270_((Entity)this.target) < this.minDistance && this.hasRangedItemInMainhand() && !this.hasRangedItemInOffhand() || (double)this.hostMob.m_20270_((Entity)this.target) > this.maxDistance && !this.hasRangedItemInMainhand() && this.hasRangedItemInOffhand()) && this.hostMob.m_142582_((Entity)this.target);
    }

    public void m_8041_() {
        this.target = null;
    }

    public void m_8037_() {
        if ((double)this.hostMob.m_20270_((Entity)this.target) < this.minDistance && this.hasRangedItemInMainhand() && !this.hasRangedItemInOffhand()) {
            this.swapWeapons();
        } else if ((double)this.hostMob.m_20270_((Entity)this.target) > this.maxDistance && !this.hasRangedItemInMainhand() && this.hasRangedItemInOffhand()) {
            this.swapWeapons();
        }
    }
}

