/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.goals.switchcombat;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.SnowballItem;

public class ThrowAndMeleeAttackGoal<T extends PathfinderMob>
extends MeleeAttackGoal {
    public final T hostCreature;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;

    public ThrowAndMeleeAttackGoal(T rangedAttackMob, double speedAmplifier, int attackInterval, float maxDistance, boolean useLongMemory) {
        super(rangedAttackMob, speedAmplifier, useLongMemory);
        this.hostCreature = rangedAttackMob;
        this.entityMoveSpeed = speedAmplifier;
        this.attackIntervalMin = attackInterval;
        this.maxRangedAttackTime = attackInterval;
        this.attackRadius = maxDistance;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.hasThrowableItemInMainhand()) {
            LivingEntity attackTarget = this.hostCreature.m_5448_();
            return attackTarget != null && attackTarget.m_6084_();
        }
        return super.m_8036_();
    }

    public boolean hasThrowableItemInMainhand() {
        return this.hostCreature.m_21205_().m_41720_() instanceof SnowballItem | this.hostCreature.m_21205_().m_41720_() instanceof EggItem;
    }

    public boolean m_8045_() {
        if (this.hasThrowableItemInMainhand()) {
            return this.m_8036_() || !this.hostCreature.m_21573_().m_26571_();
        }
        return super.m_8045_();
    }

    public void m_8041_() {
        if (this.hasThrowableItemInMainhand()) {
            this.seeTime = 0;
            this.rangedAttackTime = -1;
        } else {
            super.m_8041_();
        }
    }

    public void m_8037_() {
        LivingEntity attackTarget = this.hostCreature.m_5448_();
        if (this.hasThrowableItemInMainhand() && attackTarget != null) {
            float hostDistanceSq = (float)this.hostCreature.m_20275_(attackTarget.m_20185_(), attackTarget.m_20186_(), attackTarget.m_20189_());
            boolean canSee = this.hostCreature.m_21574_().m_148306_((Entity)attackTarget);
            this.seeTime = canSee ? ++this.seeTime : 0;
            if ((double)hostDistanceSq <= (double)this.maxAttackDistance && this.seeTime >= 5) {
                this.hostCreature.m_21573_().m_26573_();
            } else {
                this.hostCreature.m_21573_().m_5624_((Entity)attackTarget, this.entityMoveSpeed);
            }
            this.hostCreature.m_21563_().m_24960_((Entity)attackTarget, 30.0f, 30.0f);
            if (--this.rangedAttackTime == 0) {
                if (!canSee) {
                    return;
                }
                float distanceOverAttackRadius = Mth.m_14116_((float)hostDistanceSq) / this.attackRadius;
                float clampedDistanceOverAttackRadius = Mth.m_14036_((float)distanceOverAttackRadius, (float)0.1f, (float)1.0f);
                if (this.hasThrowableItemInMainhand()) {
                    this.hostCreature.m_6674_(InteractionHand.MAIN_HAND);
                }
                ((RangedAttackMob)this.hostCreature).m_6504_(attackTarget, clampedDistanceOverAttackRadius);
                this.rangedAttackTime = Mth.m_14143_((float)(distanceOverAttackRadius * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float distanceOverAttackRadius = Mth.m_14116_((float)hostDistanceSq) / this.attackRadius;
                this.rangedAttackTime = Mth.m_14143_((float)(distanceOverAttackRadius * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        } else if (attackTarget != null) {
            super.m_8037_();
        }
    }
}

