/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.interfaces;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public interface IAquaticMob {
    public static boolean isDeepEnoughToSpawn(LevelAccessor world, BlockPos blockPos) {
        return blockPos.m_123342_() < world.m_5736_() - 5;
    }

    default public <T extends LivingEntity> boolean okTarget(T aquaticMob, @Nullable LivingEntity target) {
        if (aquaticMob != this) {
            throw new IllegalArgumentException("Supplied aquaticMob is not this instance!");
        }
        if (target != null) {
            return !aquaticMob.f_19853_.m_46461_() || target.m_20069_();
        }
        return false;
    }

    default public <T extends Mob> boolean wantsToSwim(T aquaticMob) {
        if (aquaticMob != this) {
            throw new IllegalArgumentException("Supplied aquaticMob is not this instance!");
        }
        if (this.isSearchingForLand()) {
            return true;
        }
        LivingEntity target = aquaticMob.m_5448_();
        return target != null && target.m_20069_();
    }

    public void setSearchingForLand(boolean var1);

    default public <T extends Mob> boolean closeToNextPos(T aquaticMob) {
        if (aquaticMob != this) {
            throw new IllegalArgumentException("Supplied aquaticMob is not this instance!");
        }
        Path path = aquaticMob.m_21573_().m_26570_();
        if (path != null) {
            BlockPos blockpos = path.m_77406_();
            double distanceToSqr = aquaticMob.m_20275_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
            return distanceToSqr < 4.0;
        }
        return false;
    }

    default public <T extends Mob> void updateNavigation(T aquaticMob) {
        if (aquaticMob != this) {
            throw new IllegalArgumentException("Supplied aquaticMob is not this instance!");
        }
        if (!aquaticMob.f_19853_.f_46443_) {
            if (aquaticMob.m_6142_() && aquaticMob.m_20069_() && this.wantsToSwim(aquaticMob)) {
                ((IAquaticMob)aquaticMob).setNavigation((PathNavigation)((IAquaticMob)aquaticMob).getWaterNavigation());
                aquaticMob.m_20282_(true);
            } else {
                ((IAquaticMob)aquaticMob).setNavigation((PathNavigation)((IAquaticMob)aquaticMob).getGroundNavigation());
                aquaticMob.m_20282_(false);
            }
        }
    }

    default public <T extends Mob> void checkAquaticTravel(T aquaticMob, Vec3 travelVec) {
        if (aquaticMob != this) {
            throw new IllegalArgumentException("Supplied aquaticMob is not this instance!");
        }
        if (aquaticMob.m_6142_() && aquaticMob.m_20069_() && this.wantsToSwim(aquaticMob)) {
            aquaticMob.m_19920_(0.01f, travelVec);
            aquaticMob.m_6478_(MoverType.SELF, aquaticMob.m_20184_());
            aquaticMob.m_20256_(aquaticMob.m_20184_().m_82490_(0.9));
        } else {
            this.normalTravel(travelVec);
        }
    }

    public void normalTravel(Vec3 var1);

    public boolean isSearchingForLand();

    public void setNavigation(PathNavigation var1);

    public GroundPathNavigation getGroundNavigation();

    public WaterBoundPathNavigation getWaterNavigation();
}

