/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import com.infamous.dungeons_mobs.compat.DungeonsGearCompat;
import com.infamous.dungeons_mobs.goals.SmartZombieAttackGoal;
import com.infamous.dungeons_mobs.interfaces.ISmartCrossbowUser;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ZombifiedPiglin.class})
public abstract class ZombifiedPiglinEntityMixin
extends Zombie
implements ISmartCrossbowUser,
CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_CROSSBOW_USER = SynchedEntityData.m_135353_(ZombifiedPiglin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(ZombifiedPiglin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ZombifiedPiglinEntityMixin(EntityType<? extends Zombie> entityType, Level world) {
        super(entityType, world);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V"), method={"addBehaviourGoals"})
    private void addCustomGoal(GoalSelector goalSelector, int priority, Goal originalGoal) {
        if (goalSelector == this.f_21345_ && priority == 2 && originalGoal instanceof ZombieAttackGoal) {
            goalSelector.m_25352_(priority, (Goal)new SmartZombieAttackGoal(this, 1.0, false));
            goalSelector.m_25352_(priority, (Goal)new RangedCrossbowAttackGoal((Monster)this, 1.0, 8.0f));
        } else {
            goalSelector.m_25352_(priority, originalGoal);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"populateDefaultEquipmentSlots"}, cancellable=true)
    private void spawnWeapon(DifficultyInstance p_180481_1_, CallbackInfo ci) {
        this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void readAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        this.readCrossbowUserNBT(compoundNBT);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void writeAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        this.writeCrossbowUserNBT(compoundNBT);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        SpawnGroupData spawnData = super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        this.setCrossbowUser(this.m_21093_(itemStack -> itemStack.m_41720_() instanceof CrossbowItem));
        return spawnData;
    }

    private ItemStack createSpawnWeapon() {
        ItemStack meleeWeapon = DungeonsGearCompat.isLoaded() ? new ItemStack((ItemLike)DungeonsGearCompat.getGoldAxe().get()) : new ItemStack((ItemLike)Items.f_42430_);
        return (double)this.f_19796_.nextFloat() < 0.5 ? new ItemStack((ItemLike)Items.f_42717_) : meleeWeapon;
    }

    public boolean m_5886_(ProjectileWeaponItem shootableItem) {
        return shootableItem instanceof CrossbowItem;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING_CROSSBOW, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_CROSSBOW_USER, (Object)false);
    }

    @Override
    public boolean isCrossbowUser() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CROSSBOW_USER);
    }

    @Override
    public void setCrossbowUser(boolean crossbowUser) {
        this.f_19804_.m_135381_(DATA_IS_CROSSBOW_USER, (Object)crossbowUser);
    }

    @Override
    public boolean _isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean chargingCrossbow) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING_CROSSBOW, (Object)chargingCrossbow);
    }

    public void m_5811_(LivingEntity target, ItemStack weapon, Projectile projectile, float inaccuracy) {
        this.m_32322_((LivingEntity)this, target, projectile, inaccuracy, 1.6f);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6504_(LivingEntity target, float velocity) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }
}

