/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mobenchants;

import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.infamous.dungeons_libraries.utils.AreaOfEffectHelper;
import com.infamous.dungeons_mobs.DungeonsMobs;
import com.infamous.dungeons_mobs.capabilities.properties.MobProps;
import com.infamous.dungeons_mobs.capabilities.properties.MobPropsHelper;
import com.infamous.dungeons_mobs.mobenchants.NewMobEnchantUtils;
import com.infamous.dungeons_mobs.mod.ModMobEnchants;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GravityPulseMobEnchant
extends MobEnchant {
    public static final double PULL_IN_SPEED_FACTOR = 0.1;

    public GravityPulseMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void OnLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = (LivingEntity)event.getEntity();
        NewMobEnchantUtils.executeIfPresentWithLevel(entity, (MobEnchant)ModMobEnchants.GRAVITY_PULSE.get(), level -> {
            MobProps comboCap = MobPropsHelper.getMobPropsCapability((Entity)entity);
            if (comboCap == null) {
                return;
            }
            int gravityPulseTimer = comboCap.getGravityPulseTimer();
            if (gravityPulseTimer <= 0) {
                DungeonsMobs.PROXY.spawnParticles((Entity)entity, ParticleTypes.f_123760_);
                AreaOfEffectHelper.applyToNearbyEntities((LivingEntity)entity, (float)5.0f, (Predicate)AreaOfEffectHelper.getCanApplyToEnemyPredicate((LivingEntity)entity), nearbyEntity -> GravityPulseMobEnchant.pullVictimTowardsTarget(entity, nearbyEntity, ParticleTypes.f_123760_, level));
                comboCap.setGravityPulseTimer(100);
            } else {
                comboCap.setGravityPulseTimer(gravityPulseTimer - 1);
            }
        });
    }

    public static void pullVictimTowardsTarget(LivingEntity target, LivingEntity nearbyEntity, SimpleParticleType particleType, Integer level) {
        double motionX = target.m_20185_() - nearbyEntity.m_20185_();
        double motionY = target.m_20186_() - nearbyEntity.m_20186_();
        double motionZ = target.m_20189_() - nearbyEntity.m_20189_();
        Vec3 vector3d = new Vec3(motionX, motionY, motionZ).m_82490_(0.1 * (double)level.intValue());
        nearbyEntity.m_20256_(vector3d);
        DungeonsMobs.PROXY.spawnParticles((Entity)nearbyEntity, particleType);
    }
}

