/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;

public class ThrowAtTargetTask<E extends Mob>
extends Behavior<E> {
    private int attackDelay = 0;
    private final Predicate<ItemStack> throwItemPredicate;
    private final BiConsumer<E, LivingEntity> performRangedAttack;

    public ThrowAtTargetTask(Predicate<ItemStack> throwItemPredicate, BiConsumer<E, LivingEntity> performRangedAttack) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
        this.throwItemPredicate = throwItemPredicate;
        this.performRangedAttack = performRangedAttack;
    }

    protected boolean checkExtraStartConditions(ServerLevel serverWorld, E thrower) {
        LivingEntity attackTarget = ThrowAtTargetTask.getAttackTarget(thrower);
        return thrower.m_21093_(this.throwItemPredicate) && BehaviorUtils.m_22667_(thrower, (LivingEntity)attackTarget) && BehaviorUtils.m_22632_(thrower, (LivingEntity)attackTarget, (int)0);
    }

    protected boolean canStillUse(ServerLevel serverWorld, E thrower, long gameTime) {
        return thrower.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.checkExtraStartConditions(serverWorld, thrower);
    }

    protected void tick(ServerLevel serverWorld, E thrower, long gameTime) {
        LivingEntity attackTarget = ThrowAtTargetTask.getAttackTarget(thrower);
        this.lookAtTarget((Mob)thrower, attackTarget);
        this.throwAttack(thrower, attackTarget);
    }

    private void throwAttack(E thrower, LivingEntity attackTarget) {
        if (this.attackDelay > 0) {
            --this.attackDelay;
        }
        if (this.attackDelay <= 0) {
            this.performRangedAttack.accept(thrower, attackTarget);
            this.attackDelay = 50 + thrower.m_21187_().nextInt(20);
        }
    }

    private void lookAtTarget(Mob attacker, LivingEntity attackTarget) {
        attacker.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)attackTarget, true));
    }

    private static LivingEntity getAttackTarget(LivingEntity attacker) {
        return (LivingEntity)attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
    }
}

