/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.utils;

import com.infamous.dungeons_mobs.entities.jungle.AbstractVineEntity;
import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.mod.ModSoundEvents;
import com.infamous.dungeons_mobs.utils.PositionUtils;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GeomancyHelper {
    private static final int[] CONFIG_1_NORTH_ROW = new int[]{2, 3, 4, 5, 6};
    private static final int[] CONFIG_1_EAST_ROW = new int[]{6, 7, 8, 9, 10};
    private static final int[] CONFIG_1_SOUTH_ROW = new int[]{10, 11, 12, 13, 14};
    private static final int[] CONFIG_1_WEST_ROW = new int[]{14, 15, 0, 1, 2};
    public static final int[][] CONFIG_1_ROWS = new int[][]{CONFIG_1_NORTH_ROW, CONFIG_1_EAST_ROW, CONFIG_1_SOUTH_ROW, CONFIG_1_WEST_ROW};
    private static final int[] CONFIG_2_NORTH_ROW = new int[]{2, 3, 4, 5, 6, 7, 8, 1, 2};
    private static final int[] CONFIG_2_EAST_ROW = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] CONFIG_2_SOUTH_ROW = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] CONFIG_2_WEST_ROW = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[][] CONFIG_2_ROWS = new int[][]{CONFIG_2_NORTH_ROW, CONFIG_2_EAST_ROW, CONFIG_2_SOUTH_ROW, CONFIG_2_WEST_ROW};
    public static final int[][][] CONFIGS = new int[][][]{CONFIG_1_ROWS, CONFIG_2_ROWS};
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    private static boolean isValueInArray(int[] arr, int toCheckValue) {
        for (int element : arr) {
            if (element != toCheckValue) continue;
            return true;
        }
        return false;
    }

    private static double getZShift(int i, double zshift) {
        if (i >= 10 && i <= 14) {
            zshift = -2.0;
        }
        if (i >= 2 && i <= 6) {
            zshift = 2.0;
        }
        if (i == 9 || i == 15) {
            zshift = -1.0;
        }
        if (i == 1 || i == 7) {
            zshift = 1.0;
        }
        return zshift;
    }

    private static double getXShift(int i, double xshift) {
        if (i == 0 || i == 1 || i == 2 || i == 14 || i == 15) {
            xshift = -2.0;
        }
        if (i >= 6 && i <= 10) {
            xshift = 2.0;
        }
        if (i == 3 || i == 13) {
            xshift = -1.0;
        }
        if (i == 5 || i == 11) {
            xshift = 1.0;
        }
        return xshift;
    }

    private static BlockPos createCenteredBlockPosOnTarget(Entity targetEntity) {
        return new BlockPos(Math.floor(targetEntity.m_20185_()), Math.floor(targetEntity.m_20186_()), Math.floor(targetEntity.m_20189_()));
    }

    private static void summonAreaDenialConstruct(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> wallEntityType, double xshift, double zshift, Direction pillarFacing) {
        ConstructEntity constructEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity).m_142022_(xshift, 0.0, zshift);
        boolean flag = false;
        double yShift = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = casterEntity.f_19853_.m_8055_(blockpos1 = targetPos.m_7495_())).m_60783_((BlockGetter)casterEntity.f_19853_, blockpos1, Direction.UP)) continue;
            if (!casterEntity.f_19853_.m_46859_(targetPos) && !(voxelshape = (blockstate1 = casterEntity.f_19853_.m_8055_(targetPos)).m_60812_((BlockGetter)casterEntity.f_19853_, targetPos)).m_83281_()) {
                yShift = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((targetPos = targetPos.m_7495_()).m_123342_() >= Mth.m_14143_((float)targetPos.m_123342_()) - 1);
        if (flag && GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)wallEntityType.m_20615_(casterEntity.f_19853_)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.m_6034_(targetPos.m_123341_(), (double)targetPos.m_123342_() + yShift, targetPos.m_123343_());
            constructEntity.setLifeTicks(100 + casterEntity.m_21187_().nextInt(10));
            constructEntity.directionToFace = pillarFacing;
            constructEntity.spawnAreaDamage();
            casterEntity.f_19853_.m_7967_((Entity)constructEntity);
        }
    }

    private static void summonAreaDenialConstruct(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> wallEntityType, double xshift, double zshift, Direction pillarFacing) {
        ConstructEntity constructEntity;
        targetPos = targetPos.m_142022_(xshift, 0.0, zshift);
        boolean flag = false;
        double yShift = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = casterEntity.f_19853_.m_8055_(blockpos1 = targetPos.m_7495_())).m_60783_((BlockGetter)casterEntity.f_19853_, blockpos1, Direction.UP)) continue;
            if (!casterEntity.f_19853_.m_46859_(targetPos) && !(voxelshape = (blockstate1 = casterEntity.f_19853_.m_8055_(targetPos)).m_60812_((BlockGetter)casterEntity.f_19853_, targetPos)).m_83281_()) {
                yShift = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((targetPos = targetPos.m_7495_()).m_123342_() >= Mth.m_14143_((float)targetPos.m_123342_()) - 1);
        if (flag && GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)wallEntityType.m_20615_(casterEntity.f_19853_)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.m_6034_(targetPos.m_123341_(), (double)targetPos.m_123342_() + yShift, targetPos.m_123343_());
            constructEntity.setLifeTicks(100 + casterEntity.m_21187_().nextInt(10));
            constructEntity.directionToFace = pillarFacing;
            constructEntity.spawnAreaDamage();
            casterEntity.f_19853_.m_7967_((Entity)constructEntity);
        }
    }

    public static void summonOffensiveVine(LivingEntity casterEntity, LivingEntity targetEntity, EntityType<? extends AbstractVineEntity> entityType, int xShift, int zShift) {
        AbstractVineEntity vineEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget((Entity)targetEntity);
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (vineEntity = (AbstractVineEntity)entityType.m_20615_(casterEntity.f_19853_)) != null) {
            vineEntity.m_6034_(targetPos.m_123341_() + xShift, targetPos.m_123342_(), targetPos.m_123343_() + zShift);
            PositionUtils.moveToCorrectHeight((Entity)vineEntity);
            vineEntity.setDefaultFeatures();
            vineEntity.setVanishes(true);
            vineEntity.setStayTime(300 + casterEntity.m_21187_().nextInt(50));
            vineEntity.setAlwaysOut(true);
            vineEntity.setShouldRetract(false);
            double vineLength = targetEntity.m_20186_() - vineEntity.m_20186_();
            vineEntity.setLengthInBlocks((float)vineLength + 3.0f + (float)vineEntity.m_21187_().nextInt(6));
            casterEntity.f_19853_.m_7967_((Entity)vineEntity);
            if (casterEntity instanceof Mob) {
                vineEntity.m_6710_(((Mob)casterEntity).m_5448_());
            }
        }
    }

    private static void summonAreaDenialVine(LivingEntity casterEntity, LivingEntity targetEntity, EntityType<? extends AbstractVineEntity> entityType, double xshift, double zshift, Direction pillarFacing) {
        AbstractVineEntity vineEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget((Entity)targetEntity).m_142022_(xshift, 0.0, zshift);
        if (GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (vineEntity = (AbstractVineEntity)entityType.m_20615_(casterEntity.f_19853_)) != null) {
            vineEntity.m_6034_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_());
            PositionUtils.moveToCorrectHeight((Entity)vineEntity);
            vineEntity.setDefaultFeatures();
            vineEntity.setVanishes(true);
            vineEntity.setStayTime(100 + casterEntity.m_21187_().nextInt(20));
            vineEntity.setAlwaysOut(true);
            vineEntity.setShouldRetract(false);
            double vineLength = targetEntity.m_20186_() - vineEntity.m_20186_();
            vineEntity.setLengthInBlocks((float)vineLength + 3.0f + (float)vineEntity.m_21187_().nextInt(6));
            casterEntity.f_19853_.m_7967_((Entity)vineEntity);
        }
    }

    public static void summonOffensiveConstruct(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> wallEntityType, double xshift, double zshift, Direction pillarFacing) {
        ConstructEntity constructEntity;
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity).m_142022_(xshift, 0.0, zshift);
        boolean flag = false;
        double yShift = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = casterEntity.f_19853_.m_8055_(blockpos1 = targetPos.m_7495_())).m_60783_((BlockGetter)casterEntity.f_19853_, blockpos1, Direction.UP)) continue;
            if (!casterEntity.f_19853_.m_46859_(targetPos) && !(voxelshape = (blockstate1 = casterEntity.f_19853_.m_8055_(targetPos)).m_60812_((BlockGetter)casterEntity.f_19853_, targetPos)).m_83281_()) {
                yShift = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((targetPos = targetPos.m_7495_()).m_123342_() >= Mth.m_14143_((float)targetPos.m_123342_()) - 1);
        if (flag && GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)wallEntityType.m_20615_(casterEntity.f_19853_)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.m_6034_(targetPos.m_123341_(), (double)targetPos.m_123342_() + yShift, targetPos.m_123343_());
            constructEntity.setLifeTicks(100 + casterEntity.m_21187_().nextInt(10));
            constructEntity.directionToFace = pillarFacing;
            constructEntity.spawnAreaDamage();
            constructEntity.m_5496_((SoundEvent)ModSoundEvents.GEOMANCER_BOMB_SPAWN.get(), 2.0f, 1.0f);
            casterEntity.f_19853_.m_7967_((Entity)constructEntity);
        }
    }

    public static void summonOffensiveConstruct(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> wallEntityType, double xshift, double zshift, Direction pillarFacing) {
        ConstructEntity constructEntity;
        targetPos = targetPos.m_142022_(xshift, 0.0, zshift);
        boolean flag = false;
        double yShift = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = casterEntity.f_19853_.m_8055_(blockpos1 = targetPos.m_7495_())).m_60783_((BlockGetter)casterEntity.f_19853_, blockpos1, Direction.UP)) continue;
            if (!casterEntity.f_19853_.m_46859_(targetPos) && !(voxelshape = (blockstate1 = casterEntity.f_19853_.m_8055_(targetPos)).m_60812_((BlockGetter)casterEntity.f_19853_, targetPos)).m_83281_()) {
                yShift = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((targetPos = targetPos.m_7495_()).m_123342_() >= Mth.m_14143_((float)targetPos.m_123342_()) - 1);
        if (flag && GeomancyHelper.canAllowBlockEntitySpawn((Entity)casterEntity, targetPos) && (constructEntity = (ConstructEntity)wallEntityType.m_20615_(casterEntity.f_19853_)) != null) {
            constructEntity.setCaster(casterEntity);
            constructEntity.m_6034_(targetPos.m_123341_(), (double)targetPos.m_123342_() + yShift, targetPos.m_123343_());
            constructEntity.setLifeTicks(100 + casterEntity.m_21187_().nextInt(10));
            constructEntity.directionToFace = pillarFacing;
            constructEntity.m_5496_((SoundEvent)ModSoundEvents.GEOMANCER_BOMB_SPAWN.get(), 2.0f, 1.0f);
            casterEntity.f_19853_.m_7967_((Entity)constructEntity);
        }
    }

    public static void summonAreaDenialTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> entityType, int[] rowToRemove) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 15; ++constructPositionIndex) {
            if (GeomancyHelper.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = GeomancyHelper.getXShift(constructPositionIndex, xshift);
            zshift = GeomancyHelper.getZShift(constructPositionIndex, zshift);
            Direction pillarFacing = (Direction)Util.m_137545_((Object[])DIRECTIONS, (Random)casterEntity.m_21187_());
            GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetEntity, entityType, xshift, zshift, pillarFacing);
        }
    }

    public static void summonAreaDenialTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> entityType, int[] rowToRemove) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 15; ++constructPositionIndex) {
            if (GeomancyHelper.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = GeomancyHelper.getXShift(constructPositionIndex, xshift);
            zshift = GeomancyHelper.getZShift(constructPositionIndex, zshift);
            Direction pillarFacing = (Direction)Util.m_137545_((Object[])DIRECTIONS, (Random)casterEntity.m_21187_());
            GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, xshift, zshift, pillarFacing);
        }
    }

    public static void summonAreaDenialVineTrap(LivingEntity casterEntity, LivingEntity targetEntity, EntityType<? extends AbstractVineEntity> entityType, int[] rowToRemove) {
        for (int constructPositionIndex = 0; constructPositionIndex <= 15; ++constructPositionIndex) {
            if (GeomancyHelper.isValueInArray(rowToRemove, constructPositionIndex)) continue;
            double xshift = 0.0;
            double zshift = 0.0;
            xshift = GeomancyHelper.getXShift(constructPositionIndex, xshift);
            zshift = GeomancyHelper.getZShift(constructPositionIndex, zshift);
            Direction pillarFacing = (Direction)Util.m_137545_((Object[])DIRECTIONS, (Random)casterEntity.m_21187_());
            GeomancyHelper.summonAreaDenialVine(casterEntity, targetEntity, entityType, xshift, zshift, pillarFacing);
        }
    }

    public static void summonWallTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> entityType) {
        if (casterEntity.m_21187_().nextBoolean()) {
            if (casterEntity.m_21187_().nextBoolean()) {
                for (int length = -7; length < 7; ++length) {
                    GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, -3.0, (double)length, Direction.NORTH);
                }
            } else {
                for (int length = -7; length < 7; ++length) {
                    GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, 3.0, (double)length, Direction.NORTH);
                }
            }
        } else if (casterEntity.m_21187_().nextBoolean()) {
            for (int length = -7; length < 7; ++length) {
                GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)length, -3.0, Direction.NORTH);
            }
        } else {
            for (int length = -7; length < 7; ++length) {
                GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)length, 3.0, Direction.NORTH);
            }
        }
    }

    public static void summonWallTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> entityType) {
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity);
        if (casterEntity.m_21187_().nextBoolean()) {
            if (casterEntity.m_21187_().nextBoolean()) {
                for (int length = -7; length < 7; ++length) {
                    GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, -3.0, (double)length, Direction.NORTH);
                }
            } else {
                for (int length = -7; length < 7; ++length) {
                    GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, 3.0, (double)length, Direction.NORTH);
                }
            }
        } else if (casterEntity.m_21187_().nextBoolean()) {
            for (int length = -7; length < 7; ++length) {
                GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)length, -3.0, Direction.NORTH);
            }
        } else {
            for (int length = -7; length < 7; ++length) {
                GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)length, 3.0, Direction.NORTH);
            }
        }
    }

    public static void summonRandomPillarsTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> entityType) {
        for (int length = 0; length < 25; ++length) {
            GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)(-8 + casterEntity.m_21187_().nextInt(16)), (double)(-8 + casterEntity.m_21187_().nextInt(16)), Direction.NORTH);
        }
    }

    public static void summonRandomPillarsTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> entityType) {
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity);
        for (int length = 0; length < 25; ++length) {
            GeomancyHelper.summonAreaDenialConstruct(casterEntity, targetPos, entityType, (double)(-8 + casterEntity.m_21187_().nextInt(16)), (double)(-8 + casterEntity.m_21187_().nextInt(16)), Direction.NORTH);
        }
    }

    public static void summonQuadOffensiveTrap(LivingEntity casterEntity, BlockPos targetPos, EntityType<? extends ConstructEntity> entityType) {
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, -2.0, 0.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 2.0, 0.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 0.0, -2.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 0.0, 2.0, Direction.NORTH);
    }

    public static void summonQuadOffensiveTrap(LivingEntity casterEntity, Entity targetEntity, EntityType<? extends ConstructEntity> entityType) {
        BlockPos targetPos = GeomancyHelper.createCenteredBlockPosOnTarget(targetEntity);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, -2.0, 0.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 2.0, 0.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 0.0, -2.0, Direction.NORTH);
        GeomancyHelper.summonOffensiveConstruct(casterEntity, targetPos, entityType, 0.0, 2.0, Direction.NORTH);
    }

    public static boolean canAllowBlockEntitySpawn(Entity entity, BlockPos blockPos) {
        return entity.f_19853_.m_8055_(blockPos).m_60722_(Fluids.f_76191_);
    }
}

