/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ModProjectileHelper {
    private static final double RAYTRACE_DISTANCE = 16.0;

    public static InteractionHand getHandWith(LivingEntity livingEntity, Predicate<Item> itemPredicate) {
        return itemPredicate.test(livingEntity.m_21205_().m_41720_()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static ItemStack createRocket(int explosions, DyeColor ... dyeColor) {
        ItemStack rocket = new ItemStack((ItemLike)Items.f_42688_);
        ItemStack star = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag starExplosionNBT = star.m_41698_("Explosion");
        starExplosionNBT.m_128405_("Type", FireworkRocketItem.Shape.BURST.m_41236_());
        CompoundTag rocketFireworksNBT = rocket.m_41698_("Fireworks");
        ListTag rocketExplosionsNBT = new ListTag();
        CompoundTag actualStarExplosionNBT = star.m_41737_("Explosion");
        if (actualStarExplosionNBT != null) {
            int i;
            ArrayList colorList = Lists.newArrayList();
            for (i = 0; i < dyeColor.length; ++i) {
                int pinkFireworkColor = dyeColor[i].m_41070_();
                colorList.add(pinkFireworkColor);
            }
            actualStarExplosionNBT.m_128408_("Colors", (List)colorList);
            actualStarExplosionNBT.m_128408_("FadeColors", (List)colorList);
            for (i = 0; i < explosions; ++i) {
                rocketExplosionsNBT.add((Object)actualStarExplosionNBT);
            }
        }
        if (!rocketExplosionsNBT.isEmpty()) {
            rocketFireworksNBT.m_128365_("Explosions", (Tag)rocketExplosionsNBT);
        }
        return rocket;
    }

    public static HitResult getLaserRayTrace(LivingEntity shooter) {
        AABB targetAreaBoundingBox;
        EntityHitResult entityRTR;
        Level world = shooter.f_19853_;
        BlockHitResult blockRTR = (BlockHitResult)shooter.m_19907_(16.0, 1.0f, false);
        Vec3 startVec = shooter.m_20299_(1.0f);
        Vec3 lookVec = shooter.m_20252_(1.0f);
        Vec3 endVec = startVec.m_82520_(lookVec.f_82479_ * 16.0, lookVec.f_82480_ * 16.0, lookVec.f_82481_ * 16.0);
        if (blockRTR.m_6662_() != HitResult.Type.MISS) {
            endVec = blockRTR.m_82450_();
        }
        if ((entityRTR = ProjectileUtil.m_37304_((Level)world, (Entity)shooter, (Vec3)startVec, (Vec3)endVec, (AABB)(targetAreaBoundingBox = shooter.m_142469_().m_82369_(lookVec.m_82490_(16.0)).m_82400_(1.0)), entity -> !entity.m_5833_() && entity.m_6087_())) != null) {
            return entityRTR;
        }
        return blockRTR;
    }
}

