/*
 * Decompiled with CFR 0.152.
 */
package uk.me.joeclack.dimensionalworldborder;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public final class ClientboundInitialiseDimensionalBorderPacket
extends ClientboundInitializeBorderPacket {
    private final String dimensionIdentifier;

    public ClientboundInitialiseDimensionalBorderPacket(ServerLevel level, WorldBorder border) {
        super(border);
        this.dimensionIdentifier = level.m_46472_().m_135782_().toString();
    }

    public ClientboundInitialiseDimensionalBorderPacket(FriendlyByteBuf buffer) {
        super(buffer);
        this.dimensionIdentifier = buffer.m_130277_();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        super.m_5779_(buffer);
        buffer.m_130070_(this.dimensionIdentifier);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        try {
            assert (Minecraft.m_91087_().f_91073_ != null);
        }
        catch (AssertionError error) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        String clientLevelIdentifier = level.m_46472_().m_135782_().toString();
        if (!clientLevelIdentifier.equals(this.dimensionIdentifier)) {
            return;
        }
        WorldBorder worldborder = level.m_6857_();
        worldborder.m_61949_(this.m_178886_(), this.m_178887_());
        long i = this.m_178890_();
        if (i > 0L) {
            worldborder.m_61919_(this.m_178889_(), this.m_178888_(), i);
        } else {
            worldborder.m_61917_(this.m_178888_());
        }
        worldborder.m_61923_(this.m_178891_());
        worldborder.m_61952_(this.m_178893_());
        worldborder.m_61944_(this.m_178892_());
    }

    public static void encode(ClientboundInitialiseDimensionalBorderPacket packet, FriendlyByteBuf buffer) {
        packet.m_5779_(buffer);
    }

    public static ClientboundInitialiseDimensionalBorderPacket decode(FriendlyByteBuf buffer) {
        return new ClientboundInitialiseDimensionalBorderPacket(buffer);
    }

    public static void handle(ClientboundInitialiseDimensionalBorderPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientboundInitialiseDimensionalBorderPacket.lambda$handle$1(message, (Supplier)contextSupplier)));
        contextSupplier.get().setPacketHandled(true);
    }

    public String getDimensionalIdentifier() {
        return this.dimensionIdentifier;
    }

    private static /* synthetic */ Runnable lambda$handle$1(ClientboundInitialiseDimensionalBorderPacket message, Supplier contextSupplier) {
        return () -> ClientboundInitialiseDimensionalBorderPacket.lambda$handle$0(message, (Supplier)contextSupplier);
    }

    private static /* synthetic */ void lambda$handle$0(ClientboundInitialiseDimensionalBorderPacket message, Supplier contextSupplier) {
        message.handle(contextSupplier);
    }
}

