/*
 * Decompiled with CFR 0.152.
 */
package uk.me.joeclack.dimensionalworldborder;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec2;

public class DimensionalWBCommand {
    private static final DynamicCommandExceptionType ERROR_SAME_CENTER = new DynamicCommandExceptionType(DimensionalWBCommand.dimensionBorderException("commands.dimensionalworldborder.dimworldborder.center.failed"));
    private static final DynamicCommandExceptionType ERROR_SAME_SIZE = new DynamicCommandExceptionType(DimensionalWBCommand.dimensionBorderException("commands.dimensionalworldborder.dimworldborder.set.failed.nochange"));
    private static final SimpleCommandExceptionType ERROR_TOO_SMALL = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.set.failed.small"));
    private static final SimpleCommandExceptionType ERROR_TOO_BIG = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.set.failed.big", new Object[]{5.9999968E7}));
    private static final SimpleCommandExceptionType ERROR_TOO_FAR_OUT = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.set.failed.far", new Object[]{2.9999984E7}));
    private static final DynamicCommandExceptionType ERROR_SAME_WARNING_TIME = new DynamicCommandExceptionType(DimensionalWBCommand.dimensionBorderException("commands.dimensionalworldborder.dimworldborder.warning.time.failed"));
    private static final DynamicCommandExceptionType ERROR_SAME_WARNING_DISTANCE = new DynamicCommandExceptionType(DimensionalWBCommand.dimensionBorderException("commands.dimensionalworldborder.dimworldborder.warning.distance.failed"));
    private static final DynamicCommandExceptionType ERROR_SAME_DAMAGE_BUFFER = new DynamicCommandExceptionType(DimensionalWBCommand.dimensionBorderException("commands.dimensionalworldborder.dimworldborder.damage.buffer.failed"));
    private static final DynamicCommandExceptionType ERROR_SAME_DAMAGE_AMOUNT = new DynamicCommandExceptionType(DimensionalWBCommand.dimensionBorderException("commands.dimensionalworldborder.dimworldborder.damage.amount.failed"));

    private static Function<Object, Message> dimensionBorderException(String translatableComponentKey) {
        return dimensionName -> new TranslatableComponent(translatableComponentKey, new Object[]{dimensionName});
    }

    public static void register(CommandDispatcher<CommandSourceStack> p_139247_) {
        p_139247_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dimworldborder").requires(p_139268_ -> p_139268_.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82127_((String)"add").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(p_139290_ -> DimensionalWBCommand.setSize((CommandSourceStack)p_139290_.getSource(), DimensionArgument.m_88808_((CommandContext)p_139290_, (String)"dimension"), ((CommandSourceStack)p_139290_.getSource()).m_81372_().m_6857_().m_61959_() + DoubleArgumentType.getDouble((CommandContext)p_139290_, (String)"distance"), 0L))).then(Commands.m_82129_((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(p_139288_ -> DimensionalWBCommand.setSize((CommandSourceStack)p_139288_.getSource(), DimensionArgument.m_88808_((CommandContext)p_139288_, (String)"dimension"), ((CommandSourceStack)p_139288_.getSource()).m_81372_().m_6857_().m_61959_() + DoubleArgumentType.getDouble((CommandContext)p_139288_, (String)"distance"), ((CommandSourceStack)p_139288_.getSource()).m_81372_().m_6857_().m_61960_() + (long)IntegerArgumentType.getInteger((CommandContext)p_139288_, (String)"time") * 1000L)))))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg((double)-5.9999968E7, (double)5.9999968E7)).executes(p_139286_ -> DimensionalWBCommand.setSize((CommandSourceStack)p_139286_.getSource(), DimensionArgument.m_88808_((CommandContext)p_139286_, (String)"dimension"), DoubleArgumentType.getDouble((CommandContext)p_139286_, (String)"distance"), 0L))).then(Commands.m_82129_((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(p_139284_ -> DimensionalWBCommand.setSize((CommandSourceStack)p_139284_.getSource(), DimensionArgument.m_88808_((CommandContext)p_139284_, (String)"dimension"), DoubleArgumentType.getDouble((CommandContext)p_139284_, (String)"distance"), (long)IntegerArgumentType.getInteger((CommandContext)p_139284_, (String)"time") * 1000L)))))).then(Commands.m_82127_((String)"center").then(Commands.m_82129_((String)"pos", (ArgumentType)Vec2Argument.m_120822_()).executes(p_139282_ -> DimensionalWBCommand.setCenter((CommandSourceStack)p_139282_.getSource(), DimensionArgument.m_88808_((CommandContext)p_139282_, (String)"dimension"), Vec2Argument.m_120825_((CommandContext)p_139282_, (String)"pos")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"damage").then(Commands.m_82127_((String)"amount").then(Commands.m_82129_((String)"damagePerBlock", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(p_139280_ -> DimensionalWBCommand.setDamageAmount((CommandSourceStack)p_139280_.getSource(), DimensionArgument.m_88808_((CommandContext)p_139280_, (String)"dimension"), FloatArgumentType.getFloat((CommandContext)p_139280_, (String)"damagePerBlock")))))).then(Commands.m_82127_((String)"buffer").then(Commands.m_82129_((String)"distance", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(p_139278_ -> DimensionalWBCommand.setDamageBuffer((CommandSourceStack)p_139278_.getSource(), DimensionArgument.m_88808_((CommandContext)p_139278_, (String)"dimension"), FloatArgumentType.getFloat((CommandContext)p_139278_, (String)"distance"))))))).then(Commands.m_82127_((String)"get").executes(p_139276_ -> DimensionalWBCommand.getSize((CommandSourceStack)p_139276_.getSource(), DimensionArgument.m_88808_((CommandContext)p_139276_, (String)"dimension"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"warning").then(Commands.m_82127_((String)"distance").then(Commands.m_82129_((String)"distance", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(p_139266_ -> DimensionalWBCommand.setWarningDistance((CommandSourceStack)p_139266_.getSource(), DimensionArgument.m_88808_((CommandContext)p_139266_, (String)"dimension"), IntegerArgumentType.getInteger((CommandContext)p_139266_, (String)"distance")))))).then(Commands.m_82127_((String)"time").then(Commands.m_82129_((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(p_139249_ -> DimensionalWBCommand.setWarningTime((CommandSourceStack)p_139249_.getSource(), DimensionArgument.m_88808_((CommandContext)p_139249_, (String)"dimension"), IntegerArgumentType.getInteger((CommandContext)p_139249_, (String)"time"))))))));
    }

    private static int setDamageBuffer(CommandSourceStack p_139257_, ServerLevel dimension, float p_139258_) throws CommandSyntaxException {
        WorldBorder worldborder = dimension.m_6857_();
        String dimensionName = dimension.m_46472_().m_135782_().toString();
        if (worldborder.m_61964_() == (double)p_139258_) {
            throw ERROR_SAME_DAMAGE_BUFFER.create((Object)dimensionName);
        }
        worldborder.m_61939_((double)p_139258_);
        p_139257_.m_81354_((Component)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.damage.buffer.success", new Object[]{dimensionName, String.format(Locale.ROOT, "%.2f", Float.valueOf(p_139258_))}), true);
        return (int)p_139258_;
    }

    private static int setDamageAmount(CommandSourceStack p_139270_, ServerLevel dimension, float p_139271_) throws CommandSyntaxException {
        WorldBorder worldborder = dimension.m_6857_();
        String dimensionName = dimension.m_46472_().m_135782_().toString();
        if (worldborder.m_61965_() == (double)p_139271_) {
            throw ERROR_SAME_DAMAGE_AMOUNT.create((Object)dimensionName);
        }
        worldborder.m_61947_((double)p_139271_);
        p_139270_.m_81354_((Component)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.damage.amount.success", new Object[]{dimensionName, String.format(Locale.ROOT, "%.2f", Float.valueOf(p_139271_))}), true);
        return (int)p_139271_;
    }

    private static int setWarningTime(CommandSourceStack p_139260_, ServerLevel dimension, int p_139261_) throws CommandSyntaxException {
        WorldBorder worldborder = dimension.m_6857_();
        String dimensionName = dimension.m_46472_().m_135782_().toString();
        if (worldborder.m_61967_() == p_139261_) {
            throw ERROR_SAME_WARNING_TIME.create((Object)dimensionName);
        }
        worldborder.m_61944_(p_139261_);
        p_139260_.m_81354_((Component)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.warning.time.success", new Object[]{dimensionName, p_139261_}), true);
        return p_139261_;
    }

    private static int setWarningDistance(CommandSourceStack p_139273_, ServerLevel dimension, int p_139274_) throws CommandSyntaxException {
        WorldBorder worldborder = dimension.m_6857_();
        String dimensionName = dimension.m_46472_().m_135782_().toString();
        if (worldborder.m_61968_() == p_139274_) {
            throw ERROR_SAME_WARNING_DISTANCE.create((Object)dimensionName);
        }
        worldborder.m_61952_(p_139274_);
        p_139273_.m_81354_((Component)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.warning.distance.success", new Object[]{dimensionName, p_139274_}), true);
        return p_139274_;
    }

    private static int getSize(CommandSourceStack p_139251_, ServerLevel dimension) {
        double d0 = dimension.m_6857_().m_61959_();
        String dimensionName = dimension.m_46472_().m_135782_().toString();
        p_139251_.m_81354_((Component)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.get", new Object[]{dimensionName, String.format(Locale.ROOT, "%.0f", d0)}), false);
        return Mth.m_14107_((double)(d0 + 0.5));
    }

    private static int setCenter(CommandSourceStack p_139263_, ServerLevel dimension, Vec2 p_139264_) throws CommandSyntaxException {
        WorldBorder worldborder = dimension.m_6857_();
        String dimensionName = dimension.m_46472_().m_135782_().toString();
        if (worldborder.m_6347_() == (double)p_139264_.f_82470_ && worldborder.m_6345_() == (double)p_139264_.f_82471_) {
            throw ERROR_SAME_CENTER.create((Object)dimensionName);
        }
        if (!((double)Math.abs(p_139264_.f_82470_) > 2.9999984E7) && !((double)Math.abs(p_139264_.f_82471_) > 2.9999984E7)) {
            worldborder.m_61949_((double)p_139264_.f_82470_, (double)p_139264_.f_82471_);
            p_139263_.m_81354_((Component)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.center.success", new Object[]{dimensionName, String.format(Locale.ROOT, "%.2f", Float.valueOf(p_139264_.f_82470_)), String.format("%.2f", Float.valueOf(p_139264_.f_82471_))}), true);
            return 0;
        }
        throw ERROR_TOO_FAR_OUT.create();
    }

    private static int setSize(CommandSourceStack p_139253_, ServerLevel dimension, double p_139254_, long p_139255_) throws CommandSyntaxException {
        WorldBorder worldborder = dimension.m_6857_();
        String dimensionName = dimension.m_46472_().m_135782_().toString();
        double d0 = worldborder.m_61959_();
        if (d0 == p_139254_) {
            throw ERROR_SAME_SIZE.create((Object)dimensionName);
        }
        if (p_139254_ < 1.0) {
            throw ERROR_TOO_SMALL.create();
        }
        if (p_139254_ > 5.9999968E7) {
            throw ERROR_TOO_BIG.create();
        }
        if (p_139255_ > 0L) {
            worldborder.m_61919_(d0, p_139254_, p_139255_);
            if (p_139254_ > d0) {
                p_139253_.m_81354_((Component)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.set.grow", new Object[]{dimensionName, String.format(Locale.ROOT, "%.1f", p_139254_), Long.toString(p_139255_ / 1000L)}), true);
            } else {
                p_139253_.m_81354_((Component)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.set.shrink", new Object[]{dimensionName, String.format(Locale.ROOT, "%.1f", p_139254_), Long.toString(p_139255_ / 1000L)}), true);
            }
        } else {
            worldborder.m_61917_(p_139254_);
            p_139253_.m_81354_((Component)new TranslatableComponent("commands.dimensionalworldborder.dimworldborder.set.immediate", new Object[]{dimensionName, String.format(Locale.ROOT, "%.1f", p_139254_)}), true);
        }
        return (int)(p_139254_ - d0);
    }
}

