/*
 * Decompiled with CFR 0.152.
 */
package uk.me.joeclack.dimensionalworldborder;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.saveddata.SavedData;
import uk.me.joeclack.dimensionalworldborder.CompoundTagWithFallback;

public class DimensionalWBSavedData
extends SavedData {
    private DimensionalWorldborderSettings worldborderSettings = new DimensionalWorldborderSettings(WorldBorder.f_61907_);

    private DimensionalWBSavedData() {
    }

    public static DimensionalWBSavedData create() {
        return new DimensionalWBSavedData();
    }

    public static DimensionalWBSavedData load(CompoundTag tag) {
        DimensionalWBSavedData data = DimensionalWBSavedData.create();
        data.worldborderSettings = DimensionalWorldborderSettings.readFromTag(tag, WorldBorder.f_61907_);
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        this.worldborderSettings.write(tag);
        return tag;
    }

    public static DimensionalWBSavedData get(ServerLevel level) {
        return (DimensionalWBSavedData)level.m_8895_().m_164861_(DimensionalWBSavedData::load, DimensionalWBSavedData::create, "dimensionalwb");
    }

    public void applyTo(WorldBorder border) {
        this.worldborderSettings.applyTo(border);
    }

    public void setWorldborderSettings(WorldBorder.Settings settings) {
        this.worldborderSettings = new DimensionalWorldborderSettings(settings);
        this.m_77762_();
    }

    public static class DimensionalWorldborderSettings {
        private final double centerX;
        private final double centerZ;
        private final double damagePerBlock;
        private final double safeZone;
        private final int warningBlocks;
        private final int warningTime;
        private final double size;
        private final long sizeLerpTime;
        private final double sizeLerpTarget;

        DimensionalWorldborderSettings(double p_62011_, double p_62012_, double p_62013_, double p_62014_, int p_62015_, int p_62016_, double p_62017_, long p_62018_, double p_62019_) {
            this.centerX = p_62011_;
            this.centerZ = p_62012_;
            this.damagePerBlock = p_62013_;
            this.safeZone = p_62014_;
            this.warningBlocks = p_62015_;
            this.warningTime = p_62016_;
            this.size = p_62017_;
            this.sizeLerpTime = p_62018_;
            this.sizeLerpTarget = p_62019_;
        }

        DimensionalWorldborderSettings(WorldBorder.Settings p_62032_) {
            this.centerX = p_62032_.m_62036_();
            this.centerZ = p_62032_.m_62042_();
            this.damagePerBlock = p_62032_.m_62043_();
            this.safeZone = p_62032_.m_62044_();
            this.warningBlocks = p_62032_.m_62045_();
            this.warningTime = p_62032_.m_62046_();
            this.size = p_62032_.m_62047_();
            this.sizeLerpTime = p_62032_.m_62048_();
            this.sizeLerpTarget = p_62032_.m_62049_();
        }

        public double getCenterX() {
            return this.centerX;
        }

        public double getCenterZ() {
            return this.centerZ;
        }

        public double getDamagePerBlock() {
            return this.damagePerBlock;
        }

        public double getSafeZone() {
            return this.safeZone;
        }

        public int getWarningBlocks() {
            return this.warningBlocks;
        }

        public int getWarningTime() {
            return this.warningTime;
        }

        public double getSize() {
            return this.size;
        }

        public long getSizeLerpTime() {
            return this.sizeLerpTime;
        }

        public double getSizeLerpTarget() {
            return this.sizeLerpTarget;
        }

        public static DimensionalWorldborderSettings readFromTag(CompoundTag tag, WorldBorder.Settings defaultSettings) {
            double d0 = Mth.m_14008_((double)CompoundTagWithFallback.getDouble(tag, "BorderCenterX", defaultSettings.m_62036_()), (double)-2.9999984E7, (double)2.9999984E7);
            double d1 = Mth.m_14008_((double)CompoundTagWithFallback.getDouble(tag, "BorderCenterZ", defaultSettings.m_62042_()), (double)-2.9999984E7, (double)2.9999984E7);
            double d2 = CompoundTagWithFallback.getDouble(tag, "BorderSize", defaultSettings.m_62047_());
            long i = CompoundTagWithFallback.getLong(tag, "BorderSizeLerpTime", defaultSettings.m_62048_());
            double d3 = CompoundTagWithFallback.getDouble(tag, "BorderSizeLerpTarget", defaultSettings.m_62049_());
            double d4 = CompoundTagWithFallback.getDouble(tag, "BorderSafeZone", defaultSettings.m_62044_());
            double d5 = CompoundTagWithFallback.getDouble(tag, "BorderDamagePerBlock", defaultSettings.m_62043_());
            int j = CompoundTagWithFallback.getInt(tag, "BorderWarningBlocks", defaultSettings.m_62045_());
            int k = CompoundTagWithFallback.getInt(tag, "BorderWarningTime", defaultSettings.m_62046_());
            return new DimensionalWorldborderSettings(d0, d1, d5, d4, j, k, d2, i, d3);
        }

        public void write(CompoundTag p_62041_) {
            p_62041_.m_128347_("BorderCenterX", this.centerX);
            p_62041_.m_128347_("BorderCenterZ", this.centerZ);
            p_62041_.m_128347_("BorderSize", this.size);
            p_62041_.m_128356_("BorderSizeLerpTime", this.sizeLerpTime);
            p_62041_.m_128347_("BorderSafeZone", this.safeZone);
            p_62041_.m_128347_("BorderDamagePerBlock", this.damagePerBlock);
            p_62041_.m_128347_("BorderSizeLerpTarget", this.sizeLerpTarget);
            p_62041_.m_128347_("BorderWarningBlocks", (double)this.warningBlocks);
            p_62041_.m_128347_("BorderWarningTime", (double)this.warningTime);
        }

        public void applyTo(WorldBorder border) {
            border.m_61949_(this.getCenterX(), this.getCenterZ());
            border.m_61947_(this.getDamagePerBlock());
            border.m_61939_(this.getSafeZone());
            border.m_61952_(this.getWarningBlocks());
            border.m_61944_(this.getWarningTime());
            if (this.getSizeLerpTime() > 0L) {
                border.m_61919_(this.getSize(), this.getSizeLerpTarget(), this.getSizeLerpTime());
            } else {
                border.m_61917_(this.getSize());
            }
        }
    }
}

