/*
 * Decompiled with CFR 0.152.
 */
package uk.me.joeclack.dimensionalworldborder;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;
import uk.me.joeclack.dimensionalworldborder.ClientboundInitialiseDimensionalBorderPacket;
import uk.me.joeclack.dimensionalworldborder.DimensionalWBCommand;
import uk.me.joeclack.dimensionalworldborder.DimensionalWBSavedData;

@Mod(value="dimensionalworldborder")
public class DimensionalWorldBorder {
    public static final String MOD_ID = "dimensionalworldborder";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String NETWORK_PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("dimensionalworldborder", "main"), () -> "1", "1"::equals, "1"::equals);

    public DimensionalWorldBorder() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        int networkId = 0;
        NETWORK_CHANNEL.registerMessage(networkId++, ClientboundInitialiseDimensionalBorderPacket.class, ClientboundInitialiseDimensionalBorderPacket::encode, ClientboundInitialiseDimensionalBorderPacket::decode, ClientboundInitialiseDimensionalBorderPacket::handle);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        DimensionalWBCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Clearing overworld border listeners...");
        MinecraftServer server = event.getServer();
        WorldBorder overworldBorder = server.m_129783_().m_6857_();
        overworldBorder.f_61905_.clear();
        LOGGER.info("Registering own world border listeners...");
        for (ServerLevel level : server.m_129785_()) {
            this.addWorldborderListener(level);
            DimensionalWBSavedData.get(level).applyTo(level.m_6857_());
        }
        LOGGER.info("Successfully completed server-starting setup.");
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        LevelAccessor levelAccessor = event.getWorld();
        try {
            assert (levelAccessor instanceof ServerLevel);
        }
        catch (AssertionError error) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        LOGGER.info("Saving worldborder settings for '" + level.m_46472_().m_135782_().toString() + "'...");
        DimensionalWBSavedData.get(level).setWorldborderSettings(level.m_6857_().m_61970_());
    }

    public void broadcastToAllLevelPlayers(ServerLevel level, Packet<?> packet) {
        for (ServerPlayer player : level.m_6907_()) {
            player.f_8906_.m_141995_(packet);
        }
    }

    public void addWorldborderListener(final ServerLevel level) {
        level.m_6857_().m_61929_(new BorderChangeListener(){

            public void m_6312_(WorldBorder border, double size) {
                DimensionalWorldBorder.this.broadcastToAllLevelPlayers(level, (Packet<?>)new ClientboundSetBorderSizePacket(border));
            }

            public void m_6689_(WorldBorder border, double p_11329_, double p_11330_, long p_11331_) {
                DimensionalWorldBorder.this.broadcastToAllLevelPlayers(level, (Packet<?>)new ClientboundSetBorderLerpSizePacket(border));
            }

            public void m_7721_(WorldBorder border, double centerX, double centerZ) {
                DimensionalWorldBorder.this.broadcastToAllLevelPlayers(level, (Packet<?>)new ClientboundSetBorderCenterPacket(border));
            }

            public void m_5904_(WorldBorder border, int time) {
                DimensionalWorldBorder.this.broadcastToAllLevelPlayers(level, (Packet<?>)new ClientboundSetBorderWarningDelayPacket(border));
            }

            public void m_5903_(WorldBorder border, int blocks) {
                DimensionalWorldBorder.this.broadcastToAllLevelPlayers(level, (Packet<?>)new ClientboundSetBorderWarningDistancePacket(border));
            }

            public void m_6315_(WorldBorder border, double perBlockDamage) {
            }

            public void m_6313_(WorldBorder border, double damageSafeZone) {
            }
        });
    }
}

