/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunky.util.Formatting;
import org.popcraft.chunky.util.Input;

public class CenterCommand
extends ChunkyCommand {
    public CenterCommand(Chunky chunky) {
        super(chunky);
    }

    @Override
    public void execute(Sender sender, String[] args) {
        double centerZ;
        double centerX;
        Optional<Object> newX = Optional.empty();
        if (args.length > 1) {
            newX = Input.tryDoubleSuffixed(args[1]);
        }
        Optional<Object> newZ = Optional.empty();
        if (args.length > 2) {
            newZ = Input.tryDoubleSuffixed(args[2]);
        }
        if (!newX.isPresent() && !newZ.isPresent()) {
            Location coordinate = sender.getLocation();
            centerX = coordinate.getX();
            centerZ = coordinate.getZ();
        } else if (newX.isPresent() && newZ.isPresent()) {
            centerX = (Double)newX.get();
            centerZ = (Double)newZ.get();
        } else {
            sender.sendMessage("help_center", new Object[0]);
            return;
        }
        if (Input.isPastWorldLimit(centerX) || Input.isPastWorldLimit(centerZ)) {
            sender.sendMessage("help_center", new Object[0]);
            return;
        }
        this.chunky.getSelection().center(centerX, centerZ);
        sender.sendMessagePrefixed("format_center", Formatting.number(centerX), Formatting.number(centerZ));
    }
}

