/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.shape.ShapeType;
import org.popcraft.chunky.util.Formatting;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Translator;

public class StartCommand
extends ChunkyCommand {
    public StartCommand(Chunky chunky) {
        super(chunky);
    }

    @Override
    public void execute(Sender sender, String[] args) {
        if (args.length > 1) {
            Optional<World> world = Input.tryWorld(this.chunky, args[1]);
            if (world.isPresent()) {
                this.chunky.getSelection().world(world.get());
            } else {
                sender.sendMessage("help_start", new Object[0]);
                return;
            }
        }
        if (args.length > 2) {
            Optional<String> shape = Input.tryShape(args[2]);
            if (shape.isPresent()) {
                this.chunky.getSelection().shape(shape.get());
            } else {
                sender.sendMessage("help_start", new Object[0]);
                return;
            }
        }
        if (args.length > 3) {
            Optional<Double> centerX = Input.tryDoubleSuffixed(args[3]).filter(cx -> !Input.isPastWorldLimit(cx));
            Optional<Double> centerZ = Input.tryDoubleSuffixed(args.length > 4 ? args[4] : null).filter(cz -> !Input.isPastWorldLimit(cz));
            if (centerX.isPresent() && centerZ.isPresent()) {
                this.chunky.getSelection().center(centerX.get(), centerZ.get());
            } else {
                sender.sendMessage("help_start", new Object[0]);
                return;
            }
        }
        if (args.length > 5) {
            Optional<Double> radiusX = Input.tryDoubleSuffixed(args[5]).filter(rx -> rx >= 0.0 && !Input.isPastWorldLimit(rx));
            if (radiusX.isPresent()) {
                this.chunky.getSelection().radius(radiusX.get());
            } else {
                sender.sendMessage("help_start", new Object[0]);
                return;
            }
        }
        if (args.length > 6) {
            Optional<Double> radiusZ = Input.tryDoubleSuffixed(args[6]).filter(rz -> rz >= 0.0 && !Input.isPastWorldLimit(rz));
            if (radiusZ.isPresent()) {
                this.chunky.getSelection().radiusZ(radiusZ.get());
            } else {
                sender.sendMessage("help_start", new Object[0]);
                return;
            }
        }
        Selection current = this.chunky.getSelection().build();
        if (this.chunky.getGenerationTasks().containsKey(current.world().getName())) {
            sender.sendMessagePrefixed("format_started_already", current.world().getName());
            return;
        }
        if (current.radiusX() > this.chunky.getLimit()) {
            sender.sendMessagePrefixed("format_start_limit", Formatting.number(this.chunky.getLimit()));
            return;
        }
        Runnable startAction = () -> {
            GenerationTask generationTask = new GenerationTask(this.chunky, current);
            this.chunky.getGenerationTasks().put(current.world().getName(), generationTask);
            this.chunky.getScheduler().runTask(generationTask);
            sender.sendMessagePrefixed("format_start", current.world().getName(), Translator.translate("shape_" + current.shape(), new Object[0]), Formatting.number(current.centerX()), Formatting.number(current.centerZ()), Formatting.radius(current));
        };
        if (this.chunky.getConfig().loadTask(current.world()).isPresent()) {
            this.chunky.setPendingAction(sender, startAction);
            sender.sendMessagePrefixed("format_start_confirm", "/chunky continue", "/chunky confirm");
        } else {
            startAction.run();
        }
    }

    @Override
    public List<String> tabSuggestions(String[] args) {
        if (args.length == 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunky.getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        if (args.length == 3) {
            return ShapeType.ALL;
        }
        return Collections.emptyList();
    }
}

