/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Input;

public class WorldCommand
extends ChunkyCommand {
    public WorldCommand(Chunky chunky) {
        super(chunky);
    }

    @Override
    public void execute(Sender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("help_world", new Object[0]);
            return;
        }
        Optional<World> newWorld = Input.tryWorld(this.chunky, String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)));
        if (!newWorld.isPresent()) {
            sender.sendMessage("help_world", new Object[0]);
            return;
        }
        this.chunky.getSelection().world(newWorld.get());
        sender.sendMessagePrefixed("format_world", newWorld.get().getName());
    }

    @Override
    public List<String> tabSuggestions(String[] args) {
        if (args.length == 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunky.getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        return Collections.emptyList();
    }
}

