/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.LevelResource;
import org.popcraft.chunky.platform.Border;
import org.popcraft.chunky.platform.ForgeBorder;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunky.util.Input;

public class ForgeWorld
implements World {
    private static final TicketType<Unit> CHUNKY = TicketType.m_9462_((String)"chunky", (unit, unit2) -> 0);
    private final ServerLevel world;
    private final Border worldBorder;

    public ForgeWorld(ServerLevel world) {
        this.world = world;
        this.worldBorder = new ForgeBorder(world.m_6857_());
    }

    @Override
    public String getName() {
        return this.world.m_46472_().m_135782_().toString();
    }

    @Override
    public boolean isChunkGenerated(int x, int z) {
        CompoundTag chunkNbt;
        if (Thread.currentThread() != this.world.m_142572_().m_6304_()) {
            return CompletableFuture.supplyAsync(() -> this.isChunkGenerated(x, z), (Executor)this.world.m_142572_()).join();
        }
        ChunkMap chunkStorage = this.world.m_7726_().f_8325_;
        ChunkPos chunkPos = new ChunkPos(x, z);
        ChunkHolder loadedChunkHolder = chunkStorage.m_140327_(chunkPos.m_45588_());
        if (loadedChunkHolder != null && loadedChunkHolder.m_140088_() == ChunkStatus.f_62326_) {
            return true;
        }
        ChunkHolder unloadedChunkHolder = (ChunkHolder)chunkStorage.f_140131_.get(chunkPos.m_45588_());
        if (unloadedChunkHolder != null && unloadedChunkHolder.m_140088_() == ChunkStatus.f_62326_) {
            return true;
        }
        try {
            chunkNbt = chunkStorage.m_140427_(chunkPos);
        }
        catch (IOException e) {
            return false;
        }
        if (chunkNbt != null && chunkNbt.m_128425_("Status", 8)) {
            return "full".equals(chunkNbt.m_128461_("Status"));
        }
        return false;
    }

    @Override
    public CompletableFuture<Void> getChunkAtAsync(int x, int z) {
        if (Thread.currentThread() != this.world.m_142572_().m_6304_()) {
            return CompletableFuture.supplyAsync(() -> this.getChunkAtAsync(x, z), (Executor)this.world.m_142572_()).join();
        }
        ChunkPos chunkPos = new ChunkPos(x, z);
        ServerChunkCache serverChunkCache = this.world.m_7726_();
        serverChunkCache.m_8387_(CHUNKY, chunkPos, 0, (Object)Unit.INSTANCE);
        serverChunkCache.m_8489_();
        ChunkMap chunkManager = serverChunkCache.f_8325_;
        ChunkHolder chunkHolder = chunkManager.m_140327_(chunkPos.m_45588_());
        CompletableFuture<Object> chunkFuture = chunkHolder == null ? CompletableFuture.completedFuture(null) : CompletableFuture.allOf(chunkHolder.m_140049_(ChunkStatus.f_62326_, chunkManager));
        chunkFuture.whenCompleteAsync((ignored, throwable) -> serverChunkCache.m_8438_(CHUNKY, chunkPos, 0, (Object)Unit.INSTANCE), (Executor)this.world.m_142572_());
        return chunkFuture;
    }

    @Override
    public UUID getUUID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSeaLevel() {
        return this.world.m_5736_();
    }

    @Override
    public Location getSpawn() {
        BlockPos pos = this.world.m_8900_();
        float rot = this.world.m_8901_();
        return new Location(this, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), rot, 0.0f);
    }

    @Override
    public Border getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public int getElevation(int x, int z) {
        return this.world.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
    }

    @Override
    public void playEffect(Player player, String effect) {
        Location location = player.getLocation();
        BlockPos pos = new BlockPos(location.getX(), location.getY(), location.getZ());
        Input.tryInteger(effect).ifPresent(eventId -> this.world.m_46796_(eventId.intValue(), pos, 0));
    }

    @Override
    public void playSound(Player player, String sound) {
        Location location = player.getLocation();
        ServerPlayer minecraftPlayer = this.world.m_142572_().m_6846_().m_11259_(player.getUUID());
        if (minecraftPlayer != null) {
            Registry.f_122821_.m_6612_(ResourceLocation.m_135820_((String)sound)).ifPresent(arg_0 -> this.lambda$playSound$5((net.minecraft.world.entity.player.Player)minecraftPlayer, location, arg_0));
        }
    }

    @Override
    public Optional<Path> getEntitiesDirectory() {
        return this.getDirectory("entities");
    }

    @Override
    public Optional<Path> getPOIDirectory() {
        return this.getDirectory("poi");
    }

    @Override
    public Optional<Path> getRegionDirectory() {
        return this.getDirectory("region");
    }

    private Optional<Path> getDirectory(String name) {
        if (name == null) {
            return Optional.empty();
        }
        Path directory = DimensionType.m_196975_((ResourceKey)this.world.m_46472_(), (Path)this.world.m_142572_().m_129843_(LevelResource.f_78182_)).normalize().resolve(name);
        return Files.exists(directory, new LinkOption[0]) ? Optional.of(directory) : Optional.empty();
    }

    public ServerLevel getWorld() {
        return this.world;
    }

    private /* synthetic */ void lambda$playSound$5(net.minecraft.world.entity.player.Player minecraftPlayer, Location location, SoundEvent soundEvent) {
        this.world.m_6263_(minecraftPlayer, location.getX(), location.getY(), location.getZ(), soundEvent, SoundSource.MASTER, 2.0f, 1.0f);
    }
}

