/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.render;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.material.FluidState;

public class EmbeddiumRenderLayerCache {
    private static final Reference2ReferenceOpenHashMap<RenderType, ImmutableList<RenderType>> SINGLE_LAYERS = new Reference2ReferenceOpenHashMap();
    private static final Reference2ReferenceOpenHashMap<StateHolder<?, ?>, ImmutableList<RenderType>> LAYERS_BY_STATE = new Reference2ReferenceOpenHashMap();
    private static final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <O, S, H extends StateHolder<O, S>> ImmutableList<RenderType> findExisting(H state) {
        long stamp = lock.readLock();
        try {
            ImmutableList immutableList = (ImmutableList)LAYERS_BY_STATE.get(state);
            return immutableList;
        }
        finally {
            lock.unlock(stamp);
        }
    }

    public static <O, S, H extends StateHolder<O, S>> ImmutableList<RenderType> forState(H state) {
        ImmutableList<RenderType> list = EmbeddiumRenderLayerCache.findExisting(state);
        if (list == null) {
            list = EmbeddiumRenderLayerCache.createList(state);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <O, S, H extends StateHolder<O, S>> ImmutableList<RenderType> createList(H state) {
        ImmutableList layerList;
        ArrayList<RenderType> foundLayers = new ArrayList<RenderType>(2);
        if (state instanceof BlockState) {
            BlockState blockState = (BlockState)state;
            for (RenderType layer : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)blockState, (RenderType)layer)) continue;
                foundLayers.add(layer);
            }
        } else if (state instanceof FluidState) {
            FluidState fluidState = (FluidState)state;
            for (RenderType layer : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((FluidState)fluidState, (RenderType)layer)) continue;
                foundLayers.add(layer);
            }
        } else {
            throw new IllegalArgumentException("Unexpected type of state received: " + state.getClass().getName());
        }
        if (foundLayers.isEmpty()) {
            layerList = ImmutableList.of();
        } else if (foundLayers.size() == 1) {
            layerList = (ImmutableList)SINGLE_LAYERS.get(foundLayers.get(0));
            Objects.requireNonNull(layerList);
        } else {
            layerList = ImmutableList.copyOf(foundLayers);
        }
        long stamp = lock.writeLock();
        try {
            LAYERS_BY_STATE.put(state, (Object)layerList);
        }
        finally {
            lock.unlock(stamp);
        }
        return layerList;
    }

    public static void invalidate() {
        long stamp = lock.writeLock();
        try {
            LAYERS_BY_STATE.clear();
        }
        finally {
            lock.unlock(stamp);
        }
    }

    static {
        for (RenderType layer : RenderType.m_110506_()) {
            SINGLE_LAYERS.put((Object)layer, (Object)ImmutableList.of((Object)layer));
        }
    }
}

