/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.base.BaseLanguageProvider;
import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.GUIHelper;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseEnterEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseExitEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.helper.Translatable;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.gui.GuiUtils;

public class WidgetButton
extends Widget {
    public boolean hovered = false;
    public ResourceLocation backgroundTexture;
    public Translatable label;
    public String fixedLabel;

    private WidgetButton() {
        this.setHeight(20);
        this.setWidth(100);
        this.backgroundTexture = GUI.defaultButtonTexture;
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseEnterEvent.class, (event, widget) -> {
            ((WidgetButton)widget).hovered = true;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
        this.addListener(MouseExitEvent.class, (event, widget) -> {
            ((WidgetButton)widget).hovered = false;
            return WidgetEventResult.CONTINUE_PROCESSING;
        });
    }

    public WidgetButton(Translatable label) {
        this();
        this.label = label;
    }

    public WidgetButton(String label) {
        this();
        this.fixedLabel = label;
    }

    public WidgetButton setBackgroundTexture(ResourceLocation backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        return this;
    }

    public WidgetButton setLabel(Translatable label) {
        this.label = label;
        return this;
    }

    public WidgetButton setLabel(String label) {
        this.fixedLabel = label;
        return this;
    }

    @Override
    public void draw(PoseStack pPoseStack, Screen screen) {
        pPoseStack.m_85836_();
        RenderSystem.m_69478_();
        pPoseStack.m_85837_(0.0, 0.0, 2.0);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.backgroundTexture);
        GUIHelper.drawModalRectWithCustomSizedTexture(pPoseStack, 0, 0, 0.0f, 0.0f, this.width, this.height, 16.0f, 16.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI.tabIcons);
        int texOffsetX = 64;
        int texOffsetY = 84;
        int overlayWidth = 20;
        GuiUtils.drawTexturedModalRect((PoseStack)pPoseStack, (int)0, (int)0, (int)texOffsetX, (int)texOffsetY, (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((PoseStack)pPoseStack, (int)(0 + this.width - 4), (int)0, (int)(texOffsetX + overlayWidth - 4), (int)texOffsetY, (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((PoseStack)pPoseStack, (int)0, (int)(this.height - 4), (int)texOffsetX, (int)(texOffsetY + overlayWidth - 4), (int)4, (int)4, (float)0.0f);
        GuiUtils.drawTexturedModalRect((PoseStack)pPoseStack, (int)(0 + this.width - 4), (int)(this.height - 4), (int)(texOffsetX + overlayWidth - 4), (int)(texOffsetY + overlayWidth - 4), (int)4, (int)4, (float)0.0f);
        GUIHelper.drawStretchedTexture(pPoseStack, 4, 0, this.width - 8, 4, texOffsetX + 4, texOffsetY, 12, 4);
        GUIHelper.drawStretchedTexture(pPoseStack, 4, this.height - 4, this.width - 8, 4, texOffsetX + 4, texOffsetY + overlayWidth - 4, 12, 4);
        GUIHelper.drawStretchedTexture(pPoseStack, 0, 4, 4, this.height - 8, texOffsetX, texOffsetY + 4, 4, 12);
        GUIHelper.drawStretchedTexture(pPoseStack, 0 + this.width - 4, 4, 4, this.height - 8, texOffsetX + overlayWidth - 4, texOffsetY + 3, 4, 12);
        Font fontrenderer = screen.getMinecraft().f_91062_;
        pPoseStack.m_85837_(0.0, 0.0, 10.0);
        this.drawButtonContent(pPoseStack, screen, fontrenderer);
        pPoseStack.m_85837_(0.0, 0.0, -10.0);
        if (!this.enabled) {
            GUIHelper.drawColoredRectangle(pPoseStack, 1, 1, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        } else if (this.hovered) {
            GUIHelper.drawColoredRectangle(pPoseStack, 1, 1, this.width - 2, this.height - 2, -2139057921);
        }
        pPoseStack.m_85849_();
    }

    protected void drawButtonContent(PoseStack pPoseStack, Screen screen, Font renderer) {
        this.drawString(pPoseStack, screen, renderer);
    }

    protected void drawString(PoseStack pPoseStack, Screen screen, Font renderer) {
        int color = 0xFFFFFF;
        String toDraw = this.fixedLabel != null ? this.fixedLabel : I18n.m_118938_((String)BaseLanguageProvider.getTranslatableLanguageKey(this.label), (Object[])new Object[0]);
        GUIHelper.drawStringCentered(pPoseStack, toDraw, screen, (float)this.width / 2.0f, (float)(this.height - 8) / 2.0f, color);
    }
}

