/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultfruitbag.config;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="vaultfruitbag", bus=Mod.EventBusSubscriber.Bus.MOD)
public class VFBConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec CONFIG;
    public static ForgeConfigSpec.ConfigValue<Boolean> ENABLE_PICKUP;
    public static ForgeConfigSpec.ConfigValue<Boolean> ENABLE_SOULBOUND;
    public static ForgeConfigSpec.ConfigValue<CostType> FRUITS_COST;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> FRUITS;
    public static List<Item> validFruits;

    public static void reloadConfig() {
        CONFIG.afterReload();
    }

    public static void updateFromServer(boolean serverPickup, boolean serverSoulbound, CostType serverCostType, List<? extends String> serverFruits) {
        ENABLE_PICKUP.set((Object)serverPickup);
        ENABLE_SOULBOUND.set((Object)serverSoulbound);
        FRUITS_COST.set((Object)serverCostType);
        FRUITS.set(serverFruits);
        validFruits.clear();
        validFruits = ((List)FRUITS.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))).collect(Collectors.toList());
    }

    private static boolean validateItemName(Object object) {
        String itemName;
        return object instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)object));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (validFruits == null) {
            validFruits = new ArrayList<Item>();
        }
        validFruits.clear();
        List get = (List)FRUITS.get();
        for (int i = 0; i < get.size() && i < 21; ++i) {
            Item value = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)get.get(i)));
            validFruits.add(value);
        }
    }

    static {
        BUILDER.push("Common");
        ENABLE_PICKUP = BUILDER.comment("Enable / Disable the possibility to auto pickup vault fruits directly to the bag.").define("Enable Pickup", false);
        ENABLE_SOULBOUND = BUILDER.comment("Enable / Disable the possibility to add Soulbound to the Fruit Bag.").define("Enable Soulbound", false);
        FRUITS_COST = BUILDER.comment("Type cost to be applied on spirit revive.").defineEnum("Cost Type", (Enum)CostType.PER_STACK);
        BUILDER.pop();
        BUILDER.push("Fruits");
        FRUITS = BUILDER.comment("List of vault fruits allowed in the bag. Max: 21 different fruits").defineList("VaultFruits", List.of("the_vault:sweet_kiwi", "the_vault:grapes", "the_vault:bitter_lemon", "the_vault:mango", "the_vault:sour_orange", "the_vault:star_fruit", "the_vault:mystic_pear"), VFBConfig::validateItemName);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }

    public static enum CostType {
        NO_COST,
        PER_STACK,
        PER_ITEM;

    }
}

