/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultfruitbag.containers;

import com.shiftthedev.vaultfruitbag.VFBRegistry;
import com.shiftthedev.vaultfruitbag.config.VFBConfig;
import com.shiftthedev.vaultfruitbag.containers.FruitSlot;
import com.shiftthedev.vaultfruitbag.items.FruitBagItem;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.ConditionalReadSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FruitBagContainer
extends OverSizedSlotContainer {
    private final int slot;
    private final Inventory inventory;
    private final List<Slot> fruitSlots = new ArrayList<Slot>();
    private int maxCollums = -1;
    private int maxRows = -1;
    private int xOffset = -1;

    public FruitBagContainer(int id, Inventory inv, int slot) {
        super(VFBRegistry.FRUIT_BAG_CONTAINER, id, inv.f_35978_);
        this.inventory = inv;
        this.slot = slot;
        if (!this.hasBag(inv.f_35978_)) {
            return;
        }
        inv.f_35978_.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(playerHandler -> {
            ItemStack bag = this.inventory.m_8020_(this.slot);
            if (bag.m_41619_()) {
                return;
            }
            bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(bagHandler -> this.initSlots((IItemHandler)playerHandler, (IItemHandler)bagHandler));
        });
    }

    private void initSlots(IItemHandler playerHandler, IItemHandler bagHandler) {
        int hotbarSlot;
        List<Item> fruits = VFBConfig.validFruits;
        for (hotbarSlot = 0; hotbarSlot < 3; ++hotbarSlot) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_((Slot)new ConditionalReadSlot(playerHandler, column + hotbarSlot * 9 + 9, 8 + column * 18, 50 + hotbarSlot * 18, this::canAccess));
            }
        }
        for (hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_((Slot)new ConditionalReadSlot(playerHandler, hotbarSlot, 8 + hotbarSlot * 18, 108, this::canAccess));
        }
        this.maxRows = (int)Math.ceil((double)fruits.size() / 7.0);
        int startY = -20 * (this.maxRows - 1);
        for (int r = 0; r < this.maxRows; ++r) {
            int columns = Math.min(7, fruits.size() - r * 7);
            int startX = 80 + columns / 2 * -20;
            if (columns % 2 == 0) {
                startX += 9;
            }
            if (this.maxCollums == -1) {
                this.maxCollums = columns;
            }
            if (this.xOffset == -1) {
                this.xOffset = startX;
            }
            for (int c = 0; c < columns; ++c) {
                int index = c + r * 7;
                Item fruit = fruits.get(index);
                if (!fruit.m_41472_()) continue;
                this.fruitSlots.add(this.m_38897_((Slot)new FruitSlot(bagHandler, index, startX + c * 20, startY + r * 20, this, fruit)));
            }
        }
    }

    public boolean m_6875_(Player player) {
        return this.hasBag(player);
    }

    public boolean canAccess(int slot, ItemStack slotStack) {
        return !(slotStack.m_41720_() instanceof FruitBagItem);
    }

    public List<Slot> getFruitSlots() {
        return this.fruitSlots;
    }

    public int getCollums() {
        return Math.max(this.maxCollums, 3);
    }

    public int getRows() {
        return Math.min(this.maxRows, 3);
    }

    public int getXOffset() {
        if (this.maxCollums < 3) {
            return 80 + this.getCollums() / 2 * -20;
        }
        return this.xOffset;
    }

    public boolean hasBag(Player player) {
        if (this.slot == -1) {
            return false;
        }
        ItemStack bagStack = this.inventory.m_8020_(this.slot);
        return !bagStack.m_41619_();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && !this.m_38903_(slotStack, 36, this.f_38839_.size(), false)) {
                return ItemStack.f_41583_;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.custom_moveOverSizedItemStackTo(slotStack, slot))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemStack;
    }

    private boolean custom_moveOverSizedItemStackTo(ItemStack sourceStack, Slot sourceSlot) {
        ItemStack slotStack;
        Slot slot1;
        int i;
        boolean flag = false;
        for (i = 0; !sourceStack.m_41619_() && i < 36; ++i) {
            int maxSize;
            slot1 = (Slot)this.f_38839_.get(i);
            slotStack = slot1.m_7993_();
            if (slotStack.m_41619_() || slotStack.m_41720_() != sourceStack.m_41720_() || !ItemStack.m_41658_((ItemStack)sourceStack, (ItemStack)slotStack) || !slot1.m_5857_(sourceStack)) continue;
            int j = slotStack.m_41613_() + sourceStack.m_41613_();
            if (j <= (maxSize = slot1.m_5866_(slotStack))) {
                sourceStack.m_41764_(0);
                if (sourceSlot != null) {
                    sourceSlot.m_5852_(sourceStack);
                }
                slotStack.m_41764_(j);
                slot1.m_5852_(slotStack);
                slot1.m_6654_();
                flag = true;
                continue;
            }
            if (slotStack.m_41613_() >= maxSize) continue;
            sourceStack.m_41774_(maxSize - slotStack.m_41613_());
            if (sourceSlot != null) {
                sourceSlot.m_5852_(sourceStack);
            }
            slotStack.m_41764_(maxSize);
            slot1.m_5852_(slotStack);
            slot1.m_6654_();
            flag = true;
        }
        if (!sourceStack.m_41619_()) {
            for (i = 0; i < 36; ++i) {
                slot1 = (Slot)this.f_38839_.get(i);
                slotStack = slot1.m_7993_();
                if (!slotStack.m_41619_() || !slot1.m_5857_(sourceStack)) continue;
                ItemStack ss = sourceStack.m_41777_();
                if (ss.m_41613_() > slot1.m_5866_(ss)) {
                    slot1.m_5852_(ss.m_41620_(slot1.m_5866_(ss)));
                } else {
                    slot1.m_5852_(ss.m_41620_(ss.m_41613_()));
                }
                if (sourceSlot instanceof FruitSlot) {
                    if (ss.m_41619_()) {
                        ((FruitSlot)sourceSlot).quickSet(sourceStack, 0);
                    } else {
                        sourceSlot.m_5852_(ss);
                    }
                }
                slot1.m_6654_();
                flag = true;
                break;
            }
        }
        return flag;
    }
}

