/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultfruitbag.events;

import com.shiftthedev.vaultfruitbag.VFBRegistry;
import com.shiftthedev.vaultfruitbag.client.FruitBagElementScreen;
import com.shiftthedev.vaultfruitbag.client.TexturesManager;
import com.shiftthedev.vaultfruitbag.helpers.FruitBagHelper;
import com.shiftthedev.vaultfruitbag.network.CycleMessage;
import com.shiftthedev.vaultfruitbag.network.NetworkManager;
import iskallia.vault.client.atlas.ITextureAtlas;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void setupClient(FMLClientSetupEvent event) {
        ClientEvents.registerPredicates();
        ClientEvents.registerScreen();
    }

    @SubscribeEvent
    public static void registerListeners(RegisterClientReloadListenersEvent event) {
        Stream<ITextureAtlas> var = TexturesManager.REGISTRY.values().stream().map(Supplier::get);
        Objects.requireNonNull(event);
        var.forEach(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0));
    }

    private static void registerScreen() {
        MenuScreens.m_96206_(VFBRegistry.FRUIT_BAG_CONTAINER, FruitBagElementScreen::new);
    }

    private static void registerPredicates() {
        ItemProperties.register((Item)VFBRegistry.FRUIT_BAG, (ResourceLocation)new ResourceLocation("opened"), (itemStack, level, livingEntity, i) -> FruitBagHelper.isFruitSelected(itemStack));
    }

    @Mod.EventBusSubscriber(modid="vaultfruitbag", value={Dist.CLIENT})
    static class ClientForgeEvents {
        ClientForgeEvents() {
        }

        @SubscribeEvent
        public static void onMouseScroll(InputEvent.MouseScrollEvent event) {
            ItemStack stack;
            double delta = event.getScrollDelta();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && player.m_6047_() && !(stack = player.m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && stack.m_150930_((Item)VFBRegistry.FRUIT_BAG)) {
                if (delta > 0.0) {
                    stack = FruitBagHelper.nextFruit(stack);
                } else if (delta < 0.0) {
                    stack = FruitBagHelper.previousFruit(stack);
                }
                NetworkManager.CHANNEL.sendToServer((Object)new CycleMessage(stack, player.m_150109_().f_35977_));
                event.setCanceled(true);
            }
        }
    }
}

