/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultfruitbag.handlers;

import com.shiftthedev.vaultfruitbag.config.VFBConfig;
import com.shiftthedev.vaultfruitbag.helpers.FruitBagHelper;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FruitBagHandler
extends ItemStackHandler {
    protected final ItemStack delegate;
    private ItemStack oldStack = null;

    public FruitBagHandler(ItemStack delegate) {
        this.delegate = delegate;
        List<ItemStack> fruits = FruitBagHelper.getFruitStacksInBag(this.delegate);
        this.setSize(fruits.size());
        if (!fruits.isEmpty()) {
            for (int i = 0; i < fruits.size(); ++i) {
                this.stacks.set(i, (Object)fruits.get(i));
            }
        }
    }

    protected void onContentsChanged(int slot) {
        ItemStack fruit = this.getStackInSlot(slot);
        if (this.oldStack != null && fruit.m_41619_()) {
            FruitBagHelper.setFruitStack(this.delegate, this.oldStack.m_41720_().getRegistryName().toString(), 0);
        } else if (!fruit.m_41619_()) {
            FruitBagHelper.setFruitStack(this.delegate, fruit.m_41720_().getRegistryName().toString(), fruit.m_41613_());
        }
        this.oldStack = null;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (stack.m_41619_()) {
            this.oldStack = (ItemStack)this.stacks.get(slot);
        }
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    public void quickSetStackInSlot(int slot, @NotNull ItemStack stack, int count) {
        this.validateSlotIndex(slot);
        if (count > 0) {
            this.setStackInSlot(slot, stack);
            return;
        }
        this.oldStack = stack;
        this.stacks.set(slot, (Object)ItemStack.f_41583_);
        this.onContentsChanged(slot);
    }

    public ItemStack extractItemGUI(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.oldStack = existing;
                this.stacks.set(slot, (Object)ItemStack.f_41583_);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.oldStack = existing;
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @NotNull ItemStack stack) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return VFBConfig.validFruits.contains(stack.m_41720_());
    }
}

