/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultfruitbag.helpers;

import com.shiftthedev.vaultfruitbag.config.VFBConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class FruitBagHelper {
    private static final String TAG = "Inventory";
    private static final String SELECTED = "selected";

    public static int isFruitSelected(ItemStack bagStack) {
        CompoundTag tag = bagStack.m_41698_(TAG);
        return tag.m_128441_(SELECTED) ? 1 : 0;
    }

    public static boolean hasFruit(ItemStack bagStack, Item fruit) {
        String fruitID;
        CompoundTag tag = bagStack.m_41698_(TAG);
        return tag.m_128441_(fruitID = fruit.getRegistryName().toString()) && tag.m_128451_(fruitID) > 0;
    }

    public static int getFruitCount(ItemStack bagStack, Item fruit) {
        String fruitID;
        CompoundTag tag = bagStack.m_41698_(TAG);
        return tag.m_128441_(fruitID = fruit.getRegistryName().toString()) ? tag.m_128451_(fruitID) : 0;
    }

    public static void extractFruit(ItemStack bagStack, Item fruit) {
        String fruitID;
        CompoundTag tag = bagStack.m_41698_(TAG);
        if (tag.m_128441_(fruitID = fruit.getRegistryName().toString()) && tag.m_128451_(fruitID) > 0) {
            FruitBagHelper.setFruitStack(bagStack, fruitID, tag.m_128451_(fruitID) - 1);
        }
        if (tag.m_128451_(fruitID) == 0) {
            FruitBagHelper.nextFruit(bagStack);
        }
    }

    public static void setFruitStack(ItemStack bagStack, String fruitID, int count) {
        CompoundTag tag = bagStack.m_41698_(TAG);
        tag.m_128405_(fruitID, count);
        if (!tag.m_128441_(SELECTED)) {
            tag.m_128359_(SELECTED, fruitID);
        } else if (count == 0) {
            FruitBagHelper.nextFruit(bagStack);
        }
    }

    public static ItemStack nextFruit(ItemStack bagStack) {
        CompoundTag tag = bagStack.m_41698_(TAG);
        List<String> fruits = FruitBagHelper.getFruitsIdsInBag(bagStack);
        if (fruits.isEmpty()) {
            if (tag.m_128441_(SELECTED)) {
                tag.m_128473_(SELECTED);
            }
            return bagStack;
        }
        if (!tag.m_128441_(SELECTED)) {
            tag.m_128359_(SELECTED, fruits.get(0));
            return bagStack;
        }
        int nextIndex = fruits.indexOf(tag.m_128461_(SELECTED)) + 1;
        if (nextIndex >= fruits.size()) {
            nextIndex = 0;
        }
        tag.m_128359_(SELECTED, fruits.get(nextIndex));
        return bagStack;
    }

    public static ItemStack previousFruit(ItemStack bagStack) {
        CompoundTag tag = bagStack.m_41698_(TAG);
        List<String> fruits = FruitBagHelper.getFruitsIdsInBag(bagStack);
        if (fruits.isEmpty()) {
            if (tag.m_128441_(SELECTED)) {
                tag.m_128473_(SELECTED);
            }
            return bagStack;
        }
        if (!tag.m_128441_(SELECTED)) {
            tag.m_128359_(SELECTED, fruits.get(fruits.size() - 1));
            return bagStack;
        }
        int previousIndex = fruits.indexOf(tag.m_128461_(SELECTED)) - 1;
        if (previousIndex < 0) {
            previousIndex = fruits.size() - 1;
        }
        tag.m_128359_(SELECTED, fruits.get(previousIndex));
        return bagStack;
    }

    public static Item getSelectedFruit(ItemStack bagStack) {
        Item item;
        CompoundTag tag = bagStack.m_41698_(TAG);
        if (tag.m_128441_(SELECTED) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.m_128461_(SELECTED)))) != null && item.m_41472_()) {
            return item;
        }
        return null;
    }

    public static List<ItemStack> getFruitStacksInBag(ItemStack bagStack) {
        CompoundTag tag = bagStack.m_41698_(TAG);
        List<Item> fruits = VFBConfig.validFruits;
        if (fruits == null || fruits.isEmpty()) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> fruitStacks = new ArrayList<ItemStack>();
        fruits.forEach(fruitItem -> {
            if (fruitItem.m_41472_()) {
                String id = fruitItem.getRegistryName().toString();
                ItemStack fruit = tag.m_128441_(id) ? new ItemStack((ItemLike)fruitItem, tag.m_128451_(id)) : new ItemStack((ItemLike)fruitItem, 0);
                fruitStacks.add(fruit);
            }
        });
        return fruitStacks;
    }

    public static List<String> getFruitsIdsInBag(ItemStack bagStack) {
        CompoundTag tag = bagStack.m_41698_(TAG);
        List<Item> fruits = VFBConfig.validFruits;
        if (fruits.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> fruitStacks = new ArrayList<String>();
        fruits.forEach(fruitItem -> {
            String id;
            if (fruitItem.m_41472_() && tag.m_128441_(id = fruitItem.getRegistryName().toString()) && tag.m_128451_(id) > 0) {
                fruitStacks.add(id);
            }
        });
        return fruitStacks;
    }
}

