/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultfruitbag.items;

import com.shiftthedev.vaultfruitbag.config.VFBConfig;
import com.shiftthedev.vaultfruitbag.containers.FruitBagContainer;
import com.shiftthedev.vaultfruitbag.handlers.FruitBagHandler;
import com.shiftthedev.vaultfruitbag.helpers.FruitBagHelper;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.ItemVaultFruit;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FruitBagItem
extends Item {
    private static final String TAG = "Inventory";
    private static final String SELECTED = "selected";

    public FruitBagItem(String id) {
        super(new Item.Properties().m_41487_(1).m_41491_(ModItems.VAULT_MOD_GROUP).m_41489_(ItemVaultFruit.VAULT_FRUIT_FOOD));
        this.setRegistryName(id);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        Item fruit;
        if (player.m_6047_()) {
            if (level.f_46443_) {
                return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
            }
            if (hand == InteractionHand.OFF_HAND) {
                return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
            }
            FruitBagItem.openGUI((ServerPlayer)player, player.m_150109_().f_35977_);
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        if (VaultUtils.isVaultLevel((Level)level) && hand == InteractionHand.MAIN_HAND && (fruit = FruitBagHelper.getSelectedFruit(player.m_21120_(hand))) != null && FruitBagHelper.hasFruit(player.m_21120_(hand), fruit)) {
            fruit.m_7203_(level, player, hand);
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        Item fruit = FruitBagHelper.getSelectedFruit(stack);
        if (fruit != null && FruitBagHelper.hasFruit(stack, fruit)) {
            fruit.m_5922_(new ItemStack((ItemLike)fruit), level, livingEntity);
            if (livingEntity instanceof Player && !((Player)livingEntity).m_150110_().f_35937_) {
                FruitBagHelper.extractFruit(stack, fruit);
            }
        }
        return stack;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public int m_8105_(ItemStack stack) {
        Item fruit = FruitBagHelper.getSelectedFruit(stack);
        if (fruit != null && FruitBagHelper.hasFruit(stack, fruit)) {
            return fruit.m_8105_(new ItemStack((ItemLike)fruit));
        }
        return super.m_8105_(stack);
    }

    private static void openGUI(ServerPlayer player, final int slot) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent("item.vaultfruitbag.bag");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
                return new FruitBagContainer(windowId, inv, slot);
            }
        }, buf -> buf.writeInt(slot));
    }

    public static NonNullSupplier<IItemHandler> getInventorySupplier(final ItemStack itemStack) {
        return new NonNullSupplier<IItemHandler>(){

            @NotNull
            public IItemHandler get() {
                return new FruitBagHandler(itemStack);
            }
        };
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? LazyOptional.of(FruitBagItem.getInventorySupplier(stack)).cast() : LazyOptional.empty();
            }
        };
    }

    public Component m_7626_(ItemStack bagStack) {
        Item fruit = FruitBagHelper.getSelectedFruit(bagStack);
        if (fruit == null || !FruitBagHelper.hasFruit(bagStack, fruit)) {
            return super.m_7626_(bagStack);
        }
        MutableComponent name = (MutableComponent)super.m_7626_(bagStack);
        name.m_130946_(" - ");
        name.m_7220_(fruit.m_7626_(new ItemStack((ItemLike)fruit)));
        return name;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag p_41424_) {
        super.m_7373_(stack, level, tooltip, p_41424_);
        tooltip.add((Component)new TranslatableComponent("tooltip.vaultfruitbag.info").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TextComponent(" "));
        List<Item> fruits = VFBConfig.validFruits;
        if (fruits == null) {
            return;
        }
        if (!fruits.isEmpty()) {
            fruits.forEach(fruit -> {
                ItemStack fruitStack = new ItemStack((ItemLike)fruit);
                tooltip.add((Component)new TranslatableComponent("tooltip.vaultfruitbag.fruit", new Object[]{FruitBagHelper.getFruitCount(stack, fruit), fruitStack.m_41611_()}));
            });
        }
        if (!((Boolean)VFBConfig.ENABLE_SOULBOUND.get()).booleanValue()) {
            return;
        }
        tooltip.add((Component)new TextComponent(" "));
        if (AttributeGearData.read((ItemStack)stack).hasAttribute(ModGearAttributes.SOULBOUND)) {
            tooltip.add((Component)new TextComponent(ModGearAttributes.SOULBOUND.getReader().getModifierName()).m_130948_(ModGearAttributes.SOULBOUND.getReader().getColoredTextStyle()));
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.vaultfruitbag.soulbound").m_130940_(ChatFormatting.GRAY));
        }
    }
}

