/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultfruitbag.mixins;

import com.shiftthedev.vaultfruitbag.config.VFBConfig;
import com.shiftthedev.vaultfruitbag.helpers.FruitBagHelper;
import com.shiftthedev.vaultfruitbag.items.FruitBagItem;
import iskallia.vault.block.entity.SpiritExtractorTileEntity;
import iskallia.vault.config.SpiritConfig;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpiritExtractorTileEntity.RecoveryCost.class}, remap=false)
public abstract class RecoveryCostMixin {
    @Shadow
    protected abstract boolean isSoulbound(ItemStack var1);

    @Shadow
    protected abstract int getItemCost(SpiritConfig.LevelCost var1, ItemStack var2);

    @Inject(method={"getItemCost"}, at={@At(value="RETURN")}, cancellable=true)
    private void getItemCost_fruitbag(SpiritConfig.LevelCost cost, ItemStack item, CallbackInfoReturnable<Integer> cir) {
        int totalItemCost = (Integer)cir.getReturnValue();
        if (!this.isSoulbound(item) && item.m_41720_() instanceof FruitBagItem && VFBConfig.FRUITS_COST.get() != VFBConfig.CostType.NO_COST) {
            int fruitsTotalCost = 0;
            List<ItemStack> fruits = FruitBagHelper.getFruitStacksInBag(item);
            for (ItemStack fruit : fruits) {
                if (fruit.m_41619_()) continue;
                fruit.m_41784_().m_128379_("bag", true);
                fruitsTotalCost = this.getItemCost(cost, fruit);
                if (fruitsTotalCost > 0) {
                    totalItemCost = VFBConfig.FRUITS_COST.get() == VFBConfig.CostType.PER_STACK ? (totalItemCost += fruitsTotalCost) : (totalItemCost += fruitsTotalCost * fruit.m_41613_());
                }
                fruit.m_41784_().m_128473_("bag");
            }
        }
        cir.setReturnValue((Object)totalItemCost);
    }
}

