/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultfruitbag.network;

import com.shiftthedev.vaultfruitbag.VaultFruitBag;
import com.shiftthedev.vaultfruitbag.config.VFBConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ConfigSyncMessage {
    private boolean pickup;
    private boolean soulbound;
    private VFBConfig.CostType costType;
    private List<? extends String> fruits;

    public ConfigSyncMessage() {
        this.pickup = (Boolean)VFBConfig.ENABLE_PICKUP.get();
        this.soulbound = (Boolean)VFBConfig.ENABLE_SOULBOUND.get();
        this.costType = (VFBConfig.CostType)((Object)VFBConfig.FRUITS_COST.get());
        this.fruits = (List)VFBConfig.FRUITS.get();
    }

    public ConfigSyncMessage(boolean pickup, boolean soulbound, VFBConfig.CostType costType, List<String> fruits) {
        this.pickup = pickup;
        this.soulbound = soulbound;
        this.costType = costType;
        this.fruits = fruits;
    }

    public static void encode(ConfigSyncMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.pickup);
        buffer.writeBoolean(message.soulbound);
        buffer.m_130068_((Enum)message.costType);
        buffer.writeInt(message.fruits.size());
        message.fruits.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
    }

    public static ConfigSyncMessage decode(FriendlyByteBuf buffer) {
        boolean pickup = buffer.readBoolean();
        boolean soulbound = buffer.readBoolean();
        VFBConfig.CostType costType = (VFBConfig.CostType)buffer.m_130066_(VFBConfig.CostType.class);
        int size = buffer.readInt();
        ArrayList<String> fruits = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            fruits.add(buffer.m_130277_());
        }
        return new ConfigSyncMessage(pickup, soulbound, costType, fruits);
    }

    public static void handle(ConfigSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            VFBConfig.updateFromServer(message.pickup, message.soulbound, message.costType, message.fruits);
            VaultFruitBag.LOGGER.info("Received config from server.");
        });
        context.setPacketHandled(true);
    }
}

