/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.creeperhost.polylib.client.modulargui.sprite.PolyTextures;
import net.creeperhost.polylib.helpers.FormatHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class GuiEnergyBar
extends GuiElement<GuiEnergyBar>
implements BackgroundRender {
    public static final Material EMPTY = PolyTextures.getUncached("widgets/energy_empty");
    public static final Material FULL = PolyTextures.getUncached("widgets/energy_full");
    private Supplier<Long> energy = () -> 0L;
    private Supplier<Long> capacity = () -> 0L;
    private BiFunction<Long, Long, List<Component>> toolTipFormatter;

    public GuiEnergyBar(@NotNull GuiParent<?> parent) {
        super(parent);
        this.setTooltipDelay(0);
        this.setToolTipFormatter(GuiEnergyBar.defaultFormatter());
    }

    public GuiEnergyBar setCapacity(long capacity) {
        return this.setCapacity(() -> capacity);
    }

    public GuiEnergyBar setCapacity(Supplier<Long> capacity) {
        this.capacity = capacity;
        return this;
    }

    public GuiEnergyBar setEnergy(long energy) {
        return this.setEnergy(() -> energy);
    }

    public GuiEnergyBar setEnergy(Supplier<Long> energy) {
        this.energy = energy;
        return this;
    }

    public long getEnergy() {
        return this.energy.get();
    }

    public long getCapacity() {
        return this.capacity.get();
    }

    public GuiEnergyBar setToolTipFormatter(BiFunction<Long, Long, List<Component>> toolTipFormatter) {
        this.toolTipFormatter = toolTipFormatter;
        this.setTooltip(() -> this.toolTipFormatter.apply(this.getEnergy(), this.getCapacity()));
        return this;
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        float p = 0.0078125f;
        float height = this.getCapacity() <= 0L ? 0.0f : (float)this.ySize() * ((float)this.getEnergy() / (float)this.getCapacity());
        float texHeight = height * p;
        render.partialSprite(EMPTY.renderType(GuiRender::texColType), this.xMin(), this.yMin(), this.xMax(), this.yMax(), EMPTY.sprite(), 0.0f, 1.0f - p * (float)this.ySize(), p * (float)this.xSize(), 1.0f, -1);
        render.partialSprite(FULL.renderType(GuiRender::texColType), this.xMin(), this.yMin() + (this.ySize() - (double)height), this.xMax(), this.yMax(), FULL.sprite(), 0.0f, 1.0f - texHeight, p * (float)this.xSize(), 1.0f, -1);
    }

    public static Assembly<GuiRectangle, GuiEnergyBar> simpleBar(@NotNull GuiParent<?> parent) {
        GuiRectangle container = GuiRectangle.vanillaSlot(parent);
        GuiEnergyBar energyBar = new GuiEnergyBar(container);
        Constraints.bind(energyBar, container, 1.0);
        return new Assembly<GuiRectangle, GuiEnergyBar>(container, energyBar);
    }

    public static BiFunction<Long, Long, List<Component>> defaultFormatter() {
        return (energy, capacity) -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(new TranslatableComponent("energy_bar.polylib.energy_storage").m_130940_(ChatFormatting.DARK_AQUA));
            boolean shift = Screen.m_96638_();
            tooltip.add(new TranslatableComponent("energy_bar.polylib.capacity").m_130940_(ChatFormatting.GOLD).m_130946_(" ").m_7220_((Component)new TextComponent(shift ? FormatHelper.addCommas(capacity) : FormatHelper.formatNumber(capacity)).m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)new TranslatableComponent("energy_bar.polylib.rf").m_130940_(ChatFormatting.GRAY))));
            tooltip.add(new TranslatableComponent("energy_bar.polylib.stored").m_130940_(ChatFormatting.GOLD).m_130946_(" ").m_7220_((Component)new TextComponent(shift ? FormatHelper.addCommas(energy) : FormatHelper.formatNumber(energy)).m_130940_(ChatFormatting.GRAY)).m_130946_(" ").m_7220_((Component)new TranslatableComponent("energy_bar.polylib.rf").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(String.format(" (%.2f%%)", (double)energy.longValue() / (double)capacity.longValue() * 100.0)).m_130940_(ChatFormatting.GRAY)));
            return tooltip;
        };
    }
}

