/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.creeperhost.polylib.PolyLibClient;
import net.creeperhost.polylib.client.modulargui.lib.ScissorHandler;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Borders;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Rectangle;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GuiRender {
    public static final RenderType SOLID = RenderType.m_173209_((String)"gui_solid", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173104_).m_110685_(RenderStateShard.f_110139_).m_110663_(RenderStateShard.f_110113_).m_110691_(false));
    private final Minecraft mc;
    private final PoseStack pose;
    private final ScissorHandler scissorHandler = new ScissorHandler();
    private final MultiBufferSource.BufferSource buffers;
    private boolean batchDraw;
    private Font fontOverride;
    private ItemStack tooltipStack = ItemStack.f_41583_;

    public GuiRender(Minecraft mc, PoseStack poseStack, MultiBufferSource.BufferSource buffers) {
        this.mc = mc;
        this.pose = poseStack;
        this.buffers = buffers;
    }

    public GuiRender(Minecraft mc, MultiBufferSource.BufferSource buffers) {
        this(mc, new PoseStack(), buffers);
    }

    public PoseStack pose() {
        return this.pose;
    }

    public MultiBufferSource.BufferSource buffers() {
        return this.buffers;
    }

    public Minecraft mc() {
        return this.mc;
    }

    public Font font() {
        return this.fontOverride == null ? this.mc().f_91062_ : this.fontOverride;
    }

    public int guiWidth() {
        return this.mc().m_91268_().m_85445_();
    }

    public int guiHeight() {
        return this.mc().m_91268_().m_85446_();
    }

    public void overrideFont(@Nullable Font font) {
        this.fontOverride = font;
    }

    public void batchDraw(Runnable batch) {
        this.flush();
        this.batchDraw = true;
        batch.run();
        this.batchDraw = false;
        this.flush();
    }

    private void flushIfUnBatched() {
        if (!this.batchDraw) {
            this.flush();
        }
    }

    private void flushIfBatched() {
        if (this.batchDraw) {
            this.flush();
        }
    }

    public void flush() {
        RenderSystem.m_69465_();
        this.buffers.m_109911_();
        RenderSystem.m_69482_();
    }

    public void rect(Rectangle rectangle, int colour) {
        this.rect(SOLID, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), colour);
    }

    public void rect(RenderType type, Rectangle rectangle, int colour) {
        this.rect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), colour);
    }

    public void rect(double x, double y, double width, double height, int colour) {
        this.fill(SOLID, x, y, x + width, y + height, colour);
    }

    public void rect(RenderType type, double x, double y, double width, double height, int colour) {
        this.fill(type, x, y, x + width, y + height, colour);
    }

    public void fill(double xMin, double yMin, double xMax, double yMax, int colour) {
        this.fill(SOLID, xMin, yMin, xMax, yMax, colour);
    }

    public void fill(RenderType type, double xMin, double yMin, double xMax, double yMax, int colour) {
        double min;
        if (xMax < xMin) {
            min = xMax;
            xMax = xMin;
            xMin = min;
        }
        if (yMax < yMin) {
            min = yMax;
            yMax = yMin;
            yMin = min;
        }
        Matrix4f mat = this.pose.m_85850_().m_85861_();
        VertexConsumer buffer = this.buffers.m_6299_(type);
        buffer.m_85982_(mat, (float)xMax, (float)yMax, 0.0f).m_193479_(colour).m_5752_();
        buffer.m_85982_(mat, (float)xMax, (float)yMin, 0.0f).m_193479_(colour).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMin, 0.0f).m_193479_(colour).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMax, 0.0f).m_193479_(colour).m_5752_();
        this.flushIfUnBatched();
    }

    public void gradientFillV(double xMin, double yMin, double xMax, double yMax, int topColour, int bottomColour) {
        this.gradientFillV(SOLID, xMin, yMin, xMax, yMax, topColour, bottomColour);
    }

    public void gradientFillV(RenderType type, double xMin, double yMin, double xMax, double yMax, int topColour, int bottomColour) {
        VertexConsumer buffer = this.buffers().m_6299_(type);
        float sA = (float)FastColor.ARGB32.m_13655_((int)topColour) / 255.0f;
        float sR = (float)FastColor.ARGB32.m_13665_((int)topColour) / 255.0f;
        float sG = (float)FastColor.ARGB32.m_13667_((int)topColour) / 255.0f;
        float sB = (float)FastColor.ARGB32.m_13669_((int)topColour) / 255.0f;
        float eA = (float)FastColor.ARGB32.m_13655_((int)bottomColour) / 255.0f;
        float eR = (float)FastColor.ARGB32.m_13665_((int)bottomColour) / 255.0f;
        float eG = (float)FastColor.ARGB32.m_13667_((int)bottomColour) / 255.0f;
        float eB = (float)FastColor.ARGB32.m_13669_((int)bottomColour) / 255.0f;
        Matrix4f mat = this.pose.m_85850_().m_85861_();
        buffer.m_85982_(mat, (float)xMax, (float)yMax, 0.0f).m_85950_(eR, eG, eB, eA).m_5752_();
        buffer.m_85982_(mat, (float)xMax, (float)yMin, 0.0f).m_85950_(sR, sG, sB, sA).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMin, 0.0f).m_85950_(sR, sG, sB, sA).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMax, 0.0f).m_85950_(eR, eG, eB, eA).m_5752_();
        this.flushIfUnBatched();
    }

    public void gradientFillH(double xMin, double yMin, double xMax, double yMax, int leftColour, int rightColour) {
        this.gradientFillH(SOLID, xMin, yMin, xMax, yMax, leftColour, rightColour);
    }

    public void gradientFillH(RenderType type, double xMin, double yMin, double xMax, double yMax, int leftColour, int rightColour) {
        VertexConsumer buffer = this.buffers().m_6299_(type);
        float sA = (float)FastColor.ARGB32.m_13655_((int)leftColour) / 255.0f;
        float sR = (float)FastColor.ARGB32.m_13665_((int)leftColour) / 255.0f;
        float sG = (float)FastColor.ARGB32.m_13667_((int)leftColour) / 255.0f;
        float sB = (float)FastColor.ARGB32.m_13669_((int)leftColour) / 255.0f;
        float eA = (float)FastColor.ARGB32.m_13655_((int)rightColour) / 255.0f;
        float eR = (float)FastColor.ARGB32.m_13665_((int)rightColour) / 255.0f;
        float eG = (float)FastColor.ARGB32.m_13667_((int)rightColour) / 255.0f;
        float eB = (float)FastColor.ARGB32.m_13669_((int)rightColour) / 255.0f;
        Matrix4f mat = this.pose.m_85850_().m_85861_();
        buffer.m_85982_(mat, (float)xMax, (float)yMax, 0.0f).m_85950_(eR, eG, eB, eA).m_5752_();
        buffer.m_85982_(mat, (float)xMax, (float)yMin, 0.0f).m_85950_(eR, eG, eB, eA).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMin, 0.0f).m_85950_(sR, sG, sB, sA).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMax, 0.0f).m_85950_(sR, sG, sB, sA).m_5752_();
        this.flushIfUnBatched();
    }

    public void borderRect(Rectangle rectangle, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, fillColour, borderColour);
    }

    public void borderRect(double x, double y, double width, double height, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(x, y, x + width, y + height, borderWidth, fillColour, borderColour);
    }

    public void borderRect(RenderType type, Rectangle rectangle, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(type, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, fillColour, borderColour);
    }

    public void borderRect(RenderType type, double x, double y, double width, double height, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(type, x, y, x + width, y + height, borderWidth, fillColour, borderColour);
    }

    public void borderFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        this.borderFill(SOLID, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour);
    }

    public void borderFill(RenderType type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        if (this.batchDraw) {
            this.borderFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour);
        } else {
            this.batchDraw(() -> this.borderFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, fillColour, borderColour));
        }
    }

    private void borderFillInternal(RenderType type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int fillColour, int borderColour) {
        this.fill(type, xMin, yMin, xMax, yMin + borderWidth, borderColour);
        this.fill(type, xMin, yMin + borderWidth, xMin + borderWidth, yMax - borderWidth, borderColour);
        this.fill(type, xMin, yMax - borderWidth, xMax, yMax, borderColour);
        this.fill(type, xMax - borderWidth, yMin + borderWidth, xMax, yMax - borderWidth, borderColour);
        if (fillColour != 0) {
            this.fill(type, xMin + borderWidth, yMin + borderWidth, xMax - borderWidth, yMax - borderWidth, fillColour);
        }
    }

    public void shadedRect(Rectangle rectangle, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(SOLID, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedRect(double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(SOLID, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedRect(Rectangle rectangle, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(SOLID, rectangle.x(), rectangle.y(), rectangle.xMax(), rectangle.yMax(), borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedRect(double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(SOLID, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedRect(RenderType type, double x, double y, double width, double height, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(type, x, y, x + width, y + height, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int fillColour) {
        this.shadedFill(SOLID, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, GuiRender.midColour(topLeftColour, bottomRightColour), fillColour);
    }

    public void shadedFill(double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.shadedFill(SOLID, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
    }

    public void shadedFill(RenderType type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        if (this.batchDraw) {
            this.shadedFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour);
        } else {
            this.batchDraw(() -> this.shadedFillInternal(type, xMin, yMin, xMax, yMax, borderWidth, topLeftColour, bottomRightColour, cornerMixColour, fillColour));
        }
    }

    public void shadedFillInternal(RenderType type, double xMin, double yMin, double xMax, double yMax, double borderWidth, int topLeftColour, int bottomRightColour, int cornerMixColour, int fillColour) {
        this.fill(type, xMin, yMin, xMax - borderWidth, yMin + borderWidth, topLeftColour);
        this.fill(type, xMin, yMin + borderWidth, xMin + borderWidth, yMax - borderWidth, topLeftColour);
        this.fill(type, xMin + borderWidth, yMax - borderWidth, xMax, yMax, bottomRightColour);
        this.fill(type, xMax - borderWidth, yMin + borderWidth, xMax, yMax - borderWidth, bottomRightColour);
        this.fill(type, xMax - borderWidth, yMin, xMax, yMin + borderWidth, cornerMixColour);
        this.fill(type, xMin, yMax - borderWidth, xMin + borderWidth, yMax, cornerMixColour);
        if (fillColour != 0) {
            this.fill(type, xMin + borderWidth, yMin + borderWidth, xMax - borderWidth, yMax - borderWidth, fillColour);
        }
    }

    public void toolTipBackground(double x, double y, double width, double height) {
        this.toolTipBackground(x, y, width, height, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipBackground(double x, double y, double width, double height, int backgroundColour, int borderColourTop, int borderColourBottom) {
        this.toolTipBackground(x, y, width, height, backgroundColour, backgroundColour, borderColourTop, borderColourBottom, false);
    }

    public void toolTipBackground(double x, double y, double width, double height, int backgroundColourTop, int backgroundColourBottom, int borderColourTop, int borderColourBottom, boolean empty) {
        if (this.batchDraw) {
            this.toolTipBackgroundInternal(x, y, x + width, y + height, backgroundColourTop, backgroundColourBottom, borderColourTop, borderColourBottom, false);
        } else {
            this.batchDraw(() -> this.toolTipBackgroundInternal(x, y, x + width, y + height, backgroundColourTop, backgroundColourBottom, borderColourTop, borderColourBottom, false));
        }
    }

    private void toolTipBackgroundInternal(double xMin, double yMin, double xMax, double yMax, int backgroundColourTop, int backgroundColourBottom, int borderColourTop, int borderColourBottom, boolean empty) {
        this.fill(xMin + 1.0, yMin, xMax - 1.0, yMin + 1.0, backgroundColourTop);
        this.fill(xMin + 1.0, yMax - 1.0, xMax - 1.0, yMax, backgroundColourBottom);
        this.gradientFillV(xMin, yMin + 1.0, xMin + 1.0, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        this.gradientFillV(xMax - 1.0, yMin + 1.0, xMax, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        if (!empty) {
            this.gradientFillV(xMin + 1.0, yMin + 1.0, xMax - 1.0, yMax - 1.0, backgroundColourTop, backgroundColourBottom);
        }
        this.gradientFillV(xMin + 1.0, yMin + 1.0, xMin + 2.0, yMax - 1.0, borderColourTop, borderColourBottom);
        this.gradientFillV(xMax - 2.0, yMin + 1.0, xMax - 1.0, yMax - 1.0, borderColourTop, borderColourBottom);
        this.fill(xMin + 2.0, yMin + 1.0, xMax - 2.0, yMin + 2.0, borderColourTop);
        this.fill(xMin + 2.0, yMax - 2.0, xMax - 2.0, yMax - 1.0, borderColourBottom);
    }

    public void spriteRect(RenderType type, Rectangle rectangle, TextureAtlasSprite sprite) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(RenderType type, Rectangle rectangle, TextureAtlasSprite sprite, int argb) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(RenderType type, Rectangle rectangle, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), sprite, red, green, blue, alpha);
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, TextureAtlasSprite sprite) {
        this.spriteRect(type, x, y, width, height, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, TextureAtlasSprite sprite, int argb) {
        this.spriteRect(type, x, y, width, height, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.sprite(type, x, y, x + width, y + height, sprite, red, green, blue, alpha);
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite) {
        this.sprite(type, xMin, yMin, xMax, yMax, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, int argb) {
        this.sprite(type, xMin, yMin, xMax, yMax, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        VertexConsumer buffer = this.buffers().m_6299_(type);
        Matrix4f mat = this.pose.m_85850_().m_85861_();
        buffer.m_85982_(mat, (float)xMax, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
        buffer.m_85982_(mat, (float)xMax, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
        this.flushIfUnBatched();
    }

    public void spriteRect(RenderType type, Rectangle rectangle, int rotation, TextureAtlasSprite sprite) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(RenderType type, Rectangle rectangle, int rotation, TextureAtlasSprite sprite, int argb) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(RenderType type, Rectangle rectangle, int rotation, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.spriteRect(type, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, sprite, red, green, blue, alpha);
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, int rotation, TextureAtlasSprite sprite) {
        this.spriteRect(type, x, y, width, height, rotation, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, int rotation, TextureAtlasSprite sprite, int argb) {
        this.spriteRect(type, x, y, width, height, rotation, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void spriteRect(RenderType type, double x, double y, double width, double height, int rotation, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.sprite(type, x, y, x + width, y + height, rotation, sprite, red, green, blue, alpha);
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, int rotation, TextureAtlasSprite sprite) {
        this.sprite(type, xMin, yMin, xMax, yMax, rotation, sprite, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, int rotation, TextureAtlasSprite sprite, int argb) {
        this.sprite(type, xMin, yMin, xMax, yMax, rotation, sprite, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void sprite(RenderType type, double xMin, double yMin, double xMax, double yMax, int rotation, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        float[] u = new float[]{sprite.m_118409_(), sprite.m_118410_(), sprite.m_118410_(), sprite.m_118409_()};
        float[] v = new float[]{sprite.m_118412_(), sprite.m_118412_(), sprite.m_118411_(), sprite.m_118411_()};
        VertexConsumer buffer = this.buffers().m_6299_(type);
        Matrix4f mat = this.pose.m_85850_().m_85861_();
        buffer.m_85982_(mat, (float)xMax, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u[(1 + rotation) % 4], v[(1 + rotation) % 4]).m_5752_();
        buffer.m_85982_(mat, (float)xMax, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u[(2 + rotation) % 4], v[(2 + rotation) % 4]).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u[(3 + rotation) % 4], v[(3 + rotation) % 4]).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u[(0 + rotation) % 4], v[(0 + rotation) % 4]).m_5752_();
        this.flushIfUnBatched();
    }

    public void partialSpriteTex(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, double texXMin, double texYMin, double texXMax, double texYMax, int argb) {
        this.partialSpriteTex(type, xMin, yMin, xMax, yMax, sprite, texXMin, texYMin, texXMax, texYMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void partialSpriteTex(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, double texXMin, double texYMin, double texXMax, double texYMax, float red, float green, float blue, float alpha) {
        int width = sprite.m_118405_();
        int height = sprite.m_118408_();
        this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, (float)texXMin / (float)width, (float)texYMin / (float)height, (float)texXMax / (float)width, (float)texYMax / (float)height, red, green, blue, alpha);
    }

    public void partialSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, float uMin, float vMin, float uMax, float vMax, int argb) {
        this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, uMin, vMin, uMax, vMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void partialSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, float uMin, float vMin, float uMax, float vMax, float red, float green, float blue, float alpha) {
        VertexConsumer buffer = this.buffers().m_6299_(type);
        Matrix4f mat = this.pose.m_85850_().m_85861_();
        float u0 = sprite.m_118409_();
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118410_();
        float v1 = sprite.m_118412_();
        float ul = u1 - u0;
        float vl = v1 - v0;
        buffer.m_85982_(mat, (float)xMax, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u0 + uMax * ul, v0 + vMax * vl).m_5752_();
        buffer.m_85982_(mat, (float)xMax, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u0 + uMax * ul, v0 + vMin * vl).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u0 + uMin * ul, v0 + vMin * vl).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u0 + uMin * ul, v0 + vMax * vl).m_5752_();
        this.flushIfUnBatched();
    }

    public void tileSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, int argb) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, sprite.m_118405_(), sprite.m_118408_(), argb);
    }

    public void tileSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int argb) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, textureWidth, textureHeight, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tileSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, float red, float green, float blue, float alpha) {
        this.tileSprite(type, xMin, yMin, xMax, yMax, sprite, sprite.m_118405_(), sprite.m_118408_(), red, green, blue, alpha);
    }

    public void tileSprite(RenderType type, double xMin, double yMin, double xMax, double yMax, TextureAtlasSprite sprite, int textureWidth, int textureHeight, float red, float green, float blue, float alpha) {
        double width = xMax - xMin;
        double height = yMax - yMin;
        if (width <= (double)textureWidth && height <= (double)textureHeight) {
            this.partialSprite(type, xMin, yMin, xMax, yMax, sprite, 0.0f, 0.0f, (float)width / (float)textureWidth, (float)height / (float)textureHeight, red, green, blue, alpha);
        } else {
            Runnable draw = () -> {
                double xPos = xMin;
                do {
                    double sectionWidth = Math.min((double)textureWidth, xMax - xPos);
                    double uWidth = sectionWidth / (double)textureWidth;
                    double yPos = yMin;
                    do {
                        double sectionHeight = Math.min((double)textureHeight, yMax - yPos);
                        double vWidth = sectionHeight / (double)textureHeight;
                        this.partialSprite(type, xPos, yPos, xPos + sectionWidth, yPos + sectionHeight, sprite, 0.0f, 0.0f, (float)uWidth, (float)vWidth, red, green, blue, alpha);
                    } while ((yPos += (double)textureHeight) < yMax);
                } while ((xPos += (double)textureWidth) < xMax);
            };
            if (this.batchDraw) {
                draw.run();
            } else {
                this.batchDraw(draw);
            }
        }
    }

    public void texRect(Material material, Rectangle rectangle) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, Rectangle rectangle, int argb) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, Rectangle rectangle, float red, float green, float blue, float alpha) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), red, green, blue, alpha);
    }

    public void texRect(Material material, double x, double y, double width, double height) {
        this.texRect(material, x, y, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, double x, double y, double width, double height, int argb) {
        this.texRect(material, x, y, width, height, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, double x, double y, double width, double height, float red, float green, float blue, float alpha) {
        this.tex(material, x, y, x + width, y + height, red, green, blue, alpha);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax) {
        this.tex(material, xMin, yMin, xMax, yMax, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, int argb) {
        this.tex(material, xMin, yMin, xMax, yMax, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, float red, float green, float blue, float alpha) {
        TextureAtlasSprite sprite = material.sprite();
        VertexConsumer buffer = material.buffer((MultiBufferSource)this.buffers, GuiRender::texColType);
        Matrix4f mat = this.pose.m_85850_().m_85861_();
        buffer.m_85982_(mat, (float)xMax, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
        buffer.m_85982_(mat, (float)xMax, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
        this.flushIfUnBatched();
    }

    public void texRect(Material material, int rotation, Rectangle rectangle) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, int rotation, Rectangle rectangle, int argb) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, int rotation, Rectangle rectangle, float red, float green, float blue, float alpha) {
        this.texRect(material, rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height(), rotation, red, green, blue, alpha);
    }

    public void texRect(Material material, int rotation, double x, double y, double width, double height) {
        this.texRect(material, x, y, width, height, rotation, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void texRect(Material material, int rotation, double x, double y, double width, double height, int argb) {
        this.texRect(material, x, y, width, height, rotation, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void texRect(Material material, double x, double y, double width, double height, int rotation, float red, float green, float blue, float alpha) {
        this.tex(material, x, y, x + width, y + height, rotation, red, green, blue, alpha);
    }

    public void tex(Material material, int rotation, double xMin, double yMin, double xMax, double yMax) {
        this.tex(material, xMin, yMin, xMax, yMax, rotation, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, int rotation, int argb) {
        this.tex(material, xMin, yMin, xMax, yMax, rotation, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void tex(Material material, double xMin, double yMin, double xMax, double yMax, int rotation, float red, float green, float blue, float alpha) {
        TextureAtlasSprite sprite = material.sprite();
        VertexConsumer buffer = material.buffer((MultiBufferSource)this.buffers, GuiRender::texColType);
        float[] u = new float[]{sprite.m_118409_(), sprite.m_118410_(), sprite.m_118410_(), sprite.m_118409_()};
        float[] v = new float[]{sprite.m_118412_(), sprite.m_118412_(), sprite.m_118411_(), sprite.m_118411_()};
        Matrix4f mat = this.pose.m_85850_().m_85861_();
        buffer.m_85982_(mat, (float)xMax, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u[(1 + rotation) % 4], v[(1 + rotation) % 4]).m_5752_();
        buffer.m_85982_(mat, (float)xMax, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u[(2 + rotation) % 4], v[(2 + rotation) % 4]).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMin, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u[(3 + rotation) % 4], v[(3 + rotation) % 4]).m_5752_();
        buffer.m_85982_(mat, (float)xMin, (float)yMax, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(u[(0 + rotation) % 4], v[(0 + rotation) % 4]).m_5752_();
        this.flushIfUnBatched();
    }

    public void dynamicTex(Material material, Rectangle rectangle, Borders borders, int argb) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), (int)borders.top(), (int)borders.left(), (int)borders.bottom(), (int)borders.right(), argb);
    }

    public void dynamicTex(Material material, Rectangle rectangle, int topBorder, int leftBorder, int bottomBorder, int rightBorder, int argb) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), topBorder, leftBorder, bottomBorder, rightBorder, argb);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder, int argb) {
        this.dynamicTex(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, GuiRender.r(argb), GuiRender.g(argb), GuiRender.b(argb), GuiRender.a(argb));
    }

    public void dynamicTex(Material material, Rectangle rectangle, Borders borders) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), (int)borders.top(), (int)borders.left(), (int)borders.bottom(), (int)borders.right());
    }

    public void dynamicTex(Material material, Rectangle rectangle, int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        this.dynamicTex(material, (int)rectangle.x(), (int)rectangle.y(), (int)rectangle.width(), (int)rectangle.height(), topBorder, leftBorder, bottomBorder, rightBorder);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder) {
        this.dynamicTex(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void dynamicTex(Material material, int x, int y, int width, int height, int topBorder, int leftBorder, int bottomBorder, int rightBorder, float red, float green, float blue, float alpha) {
        if (this.batchDraw) {
            this.dynamicTexInternal(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, red, green, blue, alpha);
        } else {
            this.batchDraw(() -> this.dynamicTexInternal(material, x, y, width, height, topBorder, leftBorder, bottomBorder, rightBorder, red, green, blue, alpha));
        }
    }

    private void dynamicTexInternal(Material material, int xPos, int yPos, int xSize, int ySize, int topBorder, int leftBorder, int bottomBorder, int rightBorder, float red, float green, float blue, float alpha) {
        TextureAtlasSprite sprite = material.sprite();
        VertexConsumer buffer = material.buffer((MultiBufferSource)this.buffers, GuiRender::texColType);
        Matrix4f mat = this.pose.m_85850_().m_85861_();
        int texWidth = sprite.m_118405_();
        int texHeight = sprite.m_118408_();
        int trimWidth = texWidth - leftBorder - rightBorder;
        int trimHeight = texHeight - topBorder - bottomBorder;
        if (xSize <= texWidth) {
            trimWidth = Math.min(trimWidth, xSize - rightBorder);
        }
        if (xSize <= 0 || ySize <= 0 || trimWidth <= 0 || trimHeight <= 0) {
            return;
        }
        for (int x = 0; x < xSize; x += trimWidth) {
            int rWidth = Math.min(xSize - x, trimWidth);
            int trimU = 0;
            if (x != 0) {
                trimU = x + leftBorder + trimWidth <= xSize ? leftBorder : texWidth - (xSize - x);
            }
            this.bufferDynamic(buffer, mat, sprite, xPos + x, yPos, trimU, 0.0, rWidth, topBorder, red, green, blue, alpha);
            this.bufferDynamic(buffer, mat, sprite, xPos + x, yPos + ySize - bottomBorder, trimU, texHeight - bottomBorder, rWidth, bottomBorder, red, green, blue, alpha);
            rWidth = Math.min(xSize - x - leftBorder - rightBorder, trimWidth);
            for (int y = 0; y < ySize; y += trimHeight) {
                int rHeight = Math.min(ySize - y - topBorder - bottomBorder, trimHeight);
                int trimV = y + (texHeight - topBorder - bottomBorder) <= ySize ? topBorder : texHeight - (ySize - y);
                if (x == 0 && y + topBorder < ySize - bottomBorder) {
                    this.bufferDynamic(buffer, mat, sprite, xPos, yPos + y + topBorder, 0.0, trimV, leftBorder, rHeight, red, green, blue, alpha);
                    this.bufferDynamic(buffer, mat, sprite, xPos + xSize - rightBorder, yPos + y + topBorder, trimU + texWidth - rightBorder, trimV, rightBorder, rHeight, red, green, blue, alpha);
                }
                if (y + topBorder >= ySize - bottomBorder || x + leftBorder >= xSize - rightBorder) continue;
                this.bufferDynamic(buffer, mat, sprite, xPos + x + leftBorder, yPos + y + topBorder, leftBorder, topBorder, rWidth, rHeight, red, green, blue, alpha);
            }
        }
    }

    private void bufferDynamic(VertexConsumer builder, Matrix4f mat, TextureAtlasSprite tex, int x, int y, double textureX, double textureY, int width, int height, float red, float green, float blue, float alpha) {
        int w = tex.m_118405_();
        int h = tex.m_118408_();
        builder.m_85982_(mat, (float)x, (float)(y + height), 0.0f).m_85950_(red, green, blue, alpha).m_7421_(tex.m_118367_(textureX / (double)w * 16.0), tex.m_118393_((textureY + (double)height) / (double)h * 16.0)).m_5752_();
        builder.m_85982_(mat, (float)(x + width), (float)(y + height), 0.0f).m_85950_(red, green, blue, alpha).m_7421_(tex.m_118367_((textureX + (double)width) / (double)w * 16.0), tex.m_118393_((textureY + (double)height) / (double)h * 16.0)).m_5752_();
        builder.m_85982_(mat, (float)(x + width), (float)y, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(tex.m_118367_((textureX + (double)width) / (double)w * 16.0), tex.m_118393_(textureY / (double)h * 16.0)).m_5752_();
        builder.m_85982_(mat, (float)x, (float)y, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(tex.m_118367_(textureX / (double)w * 16.0), tex.m_118393_(textureY / (double)h * 16.0)).m_5752_();
    }

    public int drawString(@Nullable String message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(@Nullable String message, double x, double y, int colour, boolean shadow) {
        if (message == null) {
            return 0;
        }
        int i = this.font().m_92822_(message, (float)x, (float)y, colour, shadow, this.pose.m_85850_().m_85861_(), (MultiBufferSource)this.buffers, false, 0, 0xF000F0, this.font().m_92718_());
        this.flushIfUnBatched();
        return i;
    }

    public int drawString(FormattedCharSequence message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(FormattedCharSequence message, double x, double y, int colour, boolean shadow) {
        int i = this.font().m_92733_(message, (float)x, (float)y, colour, shadow, this.pose.m_85850_().m_85861_(), (MultiBufferSource)this.buffers, false, 0, 0xF000F0);
        this.flushIfUnBatched();
        return i;
    }

    public int drawString(Component message, double x, double y, int colour) {
        return this.drawString(message, x, y, colour, true);
    }

    public int drawString(Component message, double x, double y, int colour, boolean shadow) {
        return this.drawString(message.m_7532_(), x, y, colour, shadow);
    }

    public void drawWordWrap(FormattedText message, double x, double y, int width, int colour) {
        this.drawWordWrap(message, x, y, width, colour, false);
    }

    public void drawWordWrap(FormattedText message, double x, double y, int width, int colour, boolean shadow) {
        Objects.requireNonNull(this.font());
        this.drawWordWrap(message, x, y, width, colour, shadow, 9.0);
    }

    public void drawWordWrap(FormattedText message, double x, double y, int width, int colour, boolean shadow, double spacing) {
        for (FormattedCharSequence formattedcharsequence : this.font().m_92923_(message, width)) {
            this.drawString(formattedcharsequence, x, y, colour, shadow);
            y += spacing;
        }
    }

    public void drawCenteredString(String message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(String message, double x, double y, int colour, boolean shadow) {
        this.drawString(message, x - (double)this.font().m_92895_(message) / 2.0, y, colour, shadow);
    }

    public void drawCenteredString(Component message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(Component message, double x, double y, int colour, boolean shadow) {
        FormattedCharSequence formattedcharsequence = message.m_7532_();
        this.drawString(formattedcharsequence, x - (double)this.font().m_92724_(formattedcharsequence) / 2.0, y, colour, shadow);
    }

    public void drawCenteredString(FormattedCharSequence message, double x, double y, int colour) {
        this.drawCenteredString(message, x, y, colour, true);
    }

    public void drawCenteredString(FormattedCharSequence message, double x, double y, int colour, boolean shadow) {
        this.drawString(message, x - (double)this.font().m_92724_(message) / 2.0, y, colour, shadow);
    }

    public void drawScrollingString(Component component, double x, double y, double xMax, int colour, boolean shadow) {
        this.drawScrollingString(component, x, y, xMax, colour, shadow, true);
    }

    public void drawScrollingString(Component component, double x, double y, double xMax, int colour, boolean shadow, boolean doScissor) {
        double width;
        int textWidth = this.font().m_92852_((FormattedText)component);
        if ((double)textWidth > (width = xMax - x)) {
            double outside = (double)textWidth - width;
            double anim = (double)Util.m_137550_() / 1000.0;
            double e = Math.max(outside * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * anim / e)) / 2.0 + 0.5;
            double offset = Mth.m_14139_((double)f, (double)0.0, (double)outside);
            if (doScissor) {
                Objects.requireNonNull(this.font());
                this.pushScissor(x, y - 1.0, xMax, y + 9.0 + 1.0);
            }
            this.drawString(component, x - offset, y, colour, shadow);
            if (doScissor) {
                this.popScissor();
            }
        } else {
            this.drawCenteredString(component, (x + xMax) / 2.0, y, colour, shadow);
        }
    }

    public void renderTooltip(ItemStack stack, double mouseX, double mouseY) {
        this.renderTooltip(stack, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(ItemStack stack, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.tooltipStack = stack;
        List list = stack.m_41651_((Player)this.mc().f_91074_, (TooltipFlag)(this.mc().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        this.toolTipWithImage(list, stack.m_150921_(), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
        this.tooltipStack = ItemStack.f_41583_;
    }

    public void toolTipWithImage(List<Component> tooltips, Optional<TooltipComponent> tooltipImage, ItemStack stack, double mouseX, double mouseY) {
        this.toolTipWithImage(tooltips, tooltipImage, stack, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipWithImage(List<Component> tooltips, Optional<TooltipComponent> tooltipImage, ItemStack stack, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.tooltipStack = stack;
        this.toolTipWithImage(tooltips, tooltipImage, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
        this.tooltipStack = ItemStack.f_41583_;
    }

    public void toolTipWithImage(List<Component> tooltip, Optional<TooltipComponent> tooltipImage, double mouseX, double mouseY) {
        this.toolTipWithImage(tooltip, tooltipImage, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void toolTipWithImage(List<Component> tooltip, Optional<TooltipComponent> tooltipImage, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        List<ClientTooltipComponent> list = PolyLibClient.postGatherTooltipComponents(this.tooltipStack, tooltip, tooltipImage, (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(list, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
    }

    public void renderTooltip(Component message, double mouseX, double mouseY) {
        this.renderTooltip(message, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(Component message, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.renderTooltip(List.of(message.m_7532_()), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
    }

    public void componentTooltip(List<Component> tooltips, double mouseX, double mouseY) {
        this.componentTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void componentTooltip(List<Component> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        List<ClientTooltipComponent> components = PolyLibClient.postGatherTooltipComponents(this.tooltipStack, tooltips, Optional.empty(), (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(components, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
    }

    public void componentTooltip(List<? extends FormattedText> tooltips, double mouseX, double mouseY, ItemStack stack) {
        this.componentTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847, stack);
    }

    public void componentTooltip(List<? extends FormattedText> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom, ItemStack stack) {
        this.tooltipStack = stack;
        List<ClientTooltipComponent> components = PolyLibClient.postGatherTooltipComponents(stack, tooltips, Optional.empty(), (int)mouseX, this.guiWidth(), this.guiHeight(), this.font());
        this.renderTooltipInternal(components, mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
        this.tooltipStack = ItemStack.f_41583_;
    }

    public void renderTooltip(List<? extends FormattedCharSequence> tooltips, double mouseX, double mouseY) {
        this.renderTooltip(tooltips, mouseX, mouseY, -267386864, -267386864, 0x505000FF, 1344798847);
    }

    public void renderTooltip(List<? extends FormattedCharSequence> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        this.renderTooltipInternal(tooltips.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), mouseX, mouseY, backgroundTop, backgroundBottom, borderTop, borderBottom);
    }

    private void renderTooltipInternal(List<ClientTooltipComponent> tooltips, double mouseX, double mouseY, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        if (!tooltips.isEmpty()) {
            ClientTooltipComponent component;
            int i;
            PolyLibClient.ToolTipResult event = PolyLibClient.postRenderTooltipPre(this.tooltipStack, this.pose(), (int)mouseX, (int)mouseY, this.guiWidth(), this.guiHeight(), tooltips, this.font());
            if (event.canceled()) {
                return;
            }
            int width = 0;
            int height = tooltips.size() == 1 ? -2 : 0;
            for (ClientTooltipComponent line : tooltips) {
                width = Math.max(width, line.m_142069_(event.getFont()));
                height += line.m_142103_();
            }
            int xPos = event.getX() + 12;
            int yPos = Math.max(event.getY() - 12, 3);
            if (xPos + width > this.guiWidth()) {
                xPos -= 28 + width;
            }
            if (yPos + height + 6 > this.guiHeight()) {
                yPos = this.guiHeight() - height - 6;
            }
            PolyLibClient.ToolTipColour colour = PolyLibClient.postTooltipColour(this.tooltipStack, this.pose(), xPos, yPos, backgroundTop, backgroundBottom, borderTop, borderBottom, event.getFont(), tooltips);
            this.toolTipBackground(xPos - 3, yPos - 3, width + 6, height + 6, colour.getBackgroundStart(), colour.getBackgroundEnd(), colour.getBorderStart(), colour.getBorderEnd(), true);
            int linePos = yPos;
            for (i = 0; i < tooltips.size(); ++i) {
                component = tooltips.get(i);
                component.m_142440_(event.getFont(), xPos, linePos, this.pose.m_85850_().m_85861_(), this.buffers);
                linePos += component.m_142103_() + (i == 0 ? 2 : 0);
            }
            linePos = yPos;
            for (i = 0; i < tooltips.size(); ++i) {
                component = tooltips.get(i);
                component.m_183452_(event.getFont(), xPos, linePos, this.pose(), this.mc().m_91291_(), 0);
                linePos += component.m_142103_() + (i == 0 ? 2 : 0);
            }
            this.flushIfUnBatched();
        }
    }

    public void renderComponentHoverEffect(@Nullable Style style, int mouseX, int mouseY) {
        if (style != null && style.m_131186_() != null) {
            HoverEvent event = style.m_131186_();
            HoverEvent.ItemStackInfo stackInfo = (HoverEvent.ItemStackInfo)event.m_130823_(HoverEvent.Action.f_130832_);
            if (stackInfo != null) {
                this.renderTooltip(stackInfo.m_130898_(), (double)mouseX, (double)mouseY);
            } else {
                HoverEvent.EntityTooltipInfo tooltipInfo = (HoverEvent.EntityTooltipInfo)event.m_130823_(HoverEvent.Action.f_130833_);
                if (tooltipInfo != null) {
                    if (this.mc().f_91066_.f_92125_) {
                        this.componentTooltip(tooltipInfo.m_130884_(), mouseX, mouseY);
                    }
                } else {
                    Component component = (Component)event.m_130823_(HoverEvent.Action.f_130831_);
                    if (component != null) {
                        this.renderTooltip(this.font().m_92923_((FormattedText)component, Math.max(this.guiWidth() / 2, 200)), (double)mouseX, (double)mouseY);
                    }
                }
            }
        }
    }

    public void renderItem(ItemStack stack, double x, double y) {
        this.renderItem(stack, x, y, 16.0);
    }

    public void renderItem(ItemStack stack, double x, double y, double size) {
        this.renderItem((LivingEntity)this.mc().f_91074_, (Level)this.mc().f_91073_, stack, x, y, size, 0);
    }

    public void renderItem(ItemStack stack, double x, double y, double size, int modelRand) {
        this.renderItem((LivingEntity)this.mc().f_91074_, (Level)this.mc().f_91073_, stack, x, y, size, modelRand);
    }

    public void renderFakeItem(ItemStack stack, double x, double y) {
        this.renderFakeItem(stack, x, y, 16.0);
    }

    public void renderFakeItem(ItemStack stack, double x, double y, double size) {
        this.renderItem(null, (Level)this.mc().f_91073_, stack, x, y, size, 0);
    }

    public void renderItem(LivingEntity entity, ItemStack stack, double x, double y, int modelRand) {
        this.renderItem(entity, stack, x, y, 16.0, modelRand);
    }

    public void renderItem(LivingEntity entity, ItemStack stack, double x, double y, double size, int modelRand) {
        this.renderItem(entity, entity.m_183503_(), stack, x, y, size, modelRand);
    }

    public void renderItem(@Nullable LivingEntity entity, @Nullable Level level, ItemStack stack, double x, double y, double size, int modelRand) {
        if (!stack.m_41619_()) {
            BakedModel bakedmodel = this.mc().m_91291_().m_174264_(stack, level, entity, modelRand);
            this.pose.m_85836_();
            this.pose.m_85837_(x + size / 2.0, y + size / 2.0, size);
            try {
                boolean flag;
                this.pose.m_166854_(Matrix4f.m_27632_((float)1.0f, (float)-1.0f, (float)1.0f));
                this.pose.m_85841_((float)size, (float)size, (float)size);
                boolean bl = flag = !bakedmodel.m_7547_();
                if (flag) {
                    Lighting.m_84930_();
                }
                this.mc().m_91291_().m_115143_(stack, ItemTransforms.TransformType.GUI, false, this.pose, (MultiBufferSource)this.buffers, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
                this.flush();
                if (flag) {
                    Lighting.m_84931_();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
                crashreportcategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
                crashreportcategory.m_128165_("Item Stack", () -> String.valueOf(stack.m_41720_()));
                crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
                crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
                crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
                throw new ReportedException(crashreport);
            }
            this.pose.m_85849_();
        }
    }

    public void renderItemDecorations(ItemStack stack, double x, double y) {
        this.renderItemDecorations(stack, x, y, 16.0);
    }

    public void renderItemDecorations(ItemStack stack, double x, double y, double size) {
        this.renderItemDecorations(stack, x, y, size, null);
    }

    public void renderItemDecorations(ItemStack stack, double x, double y, @Nullable String text) {
        this.renderItemDecorations(stack, x, y, 16.0, text);
    }

    public void renderItemDecorations(ItemStack stack, double x, double y, double size, @Nullable String text) {
        if (!stack.m_41619_()) {
            LocalPlayer localplayer;
            float f;
            this.pose.m_85836_();
            float scale = (float)size / 16.0f;
            this.pose.m_85837_(x, y, size * 2.0 - 0.1);
            this.pose.m_85841_(scale, scale, 1.0f);
            this.pose.m_85837_(-x, -y, 0.0);
            if (stack.m_41613_() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.m_41613_()) : text;
                this.drawString(s, x + 19.0 - 2.0 - (double)this.font().m_92895_(s), y + 6.0 + 3.0, 0xFFFFFF, true);
            }
            if (stack.m_150947_()) {
                int l = stack.m_150948_();
                int i = stack.m_150949_();
                double j = x + 2.0;
                double k = y + 13.0;
                this.pose.m_85837_(0.0, 0.0, 0.04);
                this.fill(j, k, j + 13.0, k + 2.0, -16777216);
                this.pose.m_85837_(0.0, 0.0, 0.02);
                this.fill(j, k, j + (double)l, k + 1.0, i | 0xFF000000);
            }
            float f2 = f = (localplayer = this.mc().f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(stack.m_41720_(), this.mc().m_91296_());
            if (f > 0.0f) {
                double i1 = y + (double)Mth.m_14143_((float)(16.0f * (1.0f - f)));
                double j1 = i1 + (double)Mth.m_14167_((float)(16.0f * f));
                this.pose.m_85837_(0.0, 0.0, 0.02);
                this.fill(x, i1, x + 16.0, j1, Integer.MAX_VALUE);
            }
            this.pose.m_85849_();
        }
    }

    public void pushScissorRect(Rectangle rectangle) {
        this.pushScissorRect(rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height());
    }

    public void pushScissorRect(double x, double y, double width, double height) {
        this.flushIfBatched();
        this.scissorHandler.pushGuiScissor(x, y, width, height);
    }

    public void pushScissor(double xMin, double yMin, double xMax, double yMax) {
        this.flushIfBatched();
        this.scissorHandler.pushGuiScissor(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public void popScissor() {
        this.scissorHandler.popScissor();
    }

    public void setColor(float red, float green, float blue, float alpha) {
        this.flushIfBatched();
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static boolean isInRect(double minX, double minY, double width, double height, double testX, double testY) {
        return testX >= minX && testX < minX + width && testY >= minY && testY < minY + height;
    }

    public static boolean isInRect(int minX, int minY, int width, int height, double testX, double testY) {
        return testX >= (double)minX && testX < (double)(minX + width) && testY >= (double)minY && testY < (double)(minY + height);
    }

    public static int mixColours(int colour1, int colour2) {
        return GuiRender.mixColours(colour1, colour2, false);
    }

    public static int mixColours(int colour1, int colour2, boolean subtract) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        int alpha = Mth.m_14045_((int)(alpha1 + (subtract ? -alpha2 : alpha2)), (int)0, (int)255);
        int red = Mth.m_14045_((int)(red1 + (subtract ? -red2 : red2)), (int)0, (int)255);
        int green = Mth.m_14045_((int)(green1 + (subtract ? -green2 : green2)), (int)0, (int)255);
        int blue = Mth.m_14045_((int)(blue1 + (subtract ? -blue2 : blue2)), (int)0, (int)255);
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int midColour(int colour1, int colour2) {
        int alpha1 = colour1 >> 24 & 0xFF;
        int alpha2 = colour2 >> 24 & 0xFF;
        int red1 = colour1 >> 16 & 0xFF;
        int red2 = colour2 >> 16 & 0xFF;
        int green1 = colour1 >> 8 & 0xFF;
        int green2 = colour2 >> 8 & 0xFF;
        int blue1 = colour1 & 0xFF;
        int blue2 = colour2 & 0xFF;
        return (alpha2 + (alpha1 - alpha2) / 2 & 0xFF) << 24 | (red2 + (red1 - red2) / 2 & 0xFF) << 16 | (green2 + (green1 - green2) / 2 & 0xFF) << 8 | blue2 + (blue1 - blue2) / 2 & 0xFF;
    }

    private static float r(int argb) {
        return (float)FastColor.ARGB32.m_13665_((int)argb) / 255.0f;
    }

    private static float g(int argb) {
        return (float)FastColor.ARGB32.m_13667_((int)argb) / 255.0f;
    }

    private static float b(int argb) {
        return (float)FastColor.ARGB32.m_13669_((int)argb) / 255.0f;
    }

    private static float a(int argb) {
        return (float)FastColor.ARGB32.m_13655_((int)argb) / 255.0f;
    }

    public static RenderType texType(ResourceLocation location) {
        return RenderType.m_173209_((String)"tex_type", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173102_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
    }

    public static RenderType texColType(ResourceLocation location) {
        return RenderType.m_173209_((String)"tex_col_type", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173101_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).m_110685_(RenderStateShard.f_110139_).m_110661_(RenderStateShard.f_110110_).m_110691_(false));
    }
}

