/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.sprite;

import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.TextureAtlasHolder;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpriteUploader
extends TextureAtlasHolder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String prefix;
    private final ResourceLocation textureSource;

    public SpriteUploader(ResourceLocation textureSource, ResourceLocation atlasLocation, String prefix) {
        super(Minecraft.m_91087_().m_91097_(), atlasLocation, prefix);
        this.textureSource = textureSource;
        this.prefix = prefix;
    }

    public SpriteUploader(ResourceLocation textureSource, ResourceLocation atlasLocation) {
        this(textureSource, atlasLocation, null);
    }

    protected Stream<ResourceLocation> m_7535_() {
        Minecraft mc = Minecraft.m_91087_();
        try {
            return mc.m_91098_().m_6540_(this.textureSource.m_135815_(), s -> s.endsWith(".png") && ResourceLocation.m_135830_((String)s)).stream().filter(e -> e.m_135827_().equals(this.textureSource.m_135827_())).map(e -> new ResourceLocation(e.m_135827_(), e.m_135815_().replace(".png", "").replace("textures/" + this.prefix + "/", "")));
        }
        catch (ResourceLocationException e2) {
            LOGGER.error("An error occurred while attempting to find mod resources.");
            LOGGER.error("This may be caused by a mod including an invalid file in their resources.", (Throwable)e2);
            return Stream.empty();
        }
    }

    public ResourceLocation m_118906_(ResourceLocation location) {
        if (this.prefix != null) {
            return new ResourceLocation(location.m_135827_(), this.prefix + "/" + location.m_135815_());
        }
        return location;
    }

    public TextureAtlasSprite m_118901_(ResourceLocation resourceLocation) {
        return super.m_118901_(resourceLocation);
    }
}

