/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.creeperhost.polylib.PolyLibClient;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class PolyLibClientImpl {
    public static PolyLibClient.ToolTipResult postRenderTooltipPre(@NotNull ItemStack stack, PoseStack poseStack, int x, int y, int screenWidth, int screenHeight, @NotNull List<ClientTooltipComponent> components, @NotNull Font font) {
        RenderTooltipEvent.Pre preEvent = ForgeHooksClient.onRenderTooltipPre((ItemStack)stack, (PoseStack)poseStack, (int)x, (int)y, (int)screenWidth, (int)screenHeight, components, null, (Font)font);
        return new TTR(preEvent);
    }

    public static PolyLibClient.ToolTipColour postTooltipColour(@NotNull ItemStack stack, PoseStack poseStack, int x, int y, int backgroundStart, int backgroundEnd, int borderStart, int borderEnd, @NotNull Font font, @NotNull List<ClientTooltipComponent> components) {
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, poseStack, x, y, font, backgroundStart, borderStart, borderEnd, components);
        colorEvent.setBackgroundEnd(backgroundEnd);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        return new TTC(colorEvent);
    }

    public static List<ClientTooltipComponent> postGatherTooltipComponents(ItemStack stack, List<? extends FormattedText> textElements, Optional<TooltipComponent> itemComponent, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        return ForgeHooksClient.gatherTooltipComponents((ItemStack)stack, textElements, itemComponent, (int)mouseX, (int)screenWidth, (int)screenHeight, null, (Font)fallbackFont);
    }

    private static class TTR
    implements PolyLibClient.ToolTipResult {
        private final RenderTooltipEvent.Pre event;

        public TTR(RenderTooltipEvent.Pre event) {
            this.event = event;
        }

        @Override
        @NotNull
        public Font getFont() {
            return this.event.getFont();
        }

        @Override
        public boolean canceled() {
            return this.event.isCanceled();
        }

        @Override
        public int getX() {
            return this.event.getX();
        }

        @Override
        public int getY() {
            return this.event.getY();
        }
    }

    private static class TTC
    implements PolyLibClient.ToolTipColour {
        private final RenderTooltipEvent.Color event;

        public TTC(RenderTooltipEvent.Color event) {
            this.event = event;
        }

        @Override
        public int getBackgroundStart() {
            return this.event.getBackgroundStart();
        }

        @Override
        public int getBackgroundEnd() {
            return this.event.getBackgroundEnd();
        }

        @Override
        public int getBorderStart() {
            return this.event.getBorderStart();
        }

        @Override
        public int getBorderEnd() {
            return this.event.getBorderEnd();
        }
    }
}

