/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.hud.impl;

import com.alrex.parcool.client.hud.Position;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.MathUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;

@OnlyIn(value=Dist.CLIENT)
public class StaminaHUD
extends GuiComponent {
    public static final ResourceLocation STAMINA = new ResourceLocation("parcool", "textures/gui/stamina_bar.png");
    private float shadowScale = 1.0f;
    private int renderGageType = 0;
    private int renderGageTick = 0;
    private float statusValue = 0.0f;
    private float oldStatusValue = 0.0f;
    private boolean showStatus = false;

    public void onTick(TickEvent.ClientTickEvent event, LocalPlayer player) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        if (++this.renderGageTick >= 5) {
            this.renderGageTick = 0;
            if (++this.renderGageType > 2) {
                this.renderGageType = 0;
            }
        }
        this.oldStatusValue = this.statusValue;
        boolean oldShowStatus = this.showStatus;
        this.showStatus = false;
        for (Action a : parkourability.getList()) {
            if (!a.wantsToShowStatusBar(player, parkourability)) continue;
            this.showStatus = true;
            this.statusValue = a.getStatusValue(player, parkourability);
            if (this.statusValue > 1.0f) {
                this.statusValue = 1.0f;
                break;
            }
            if (!(this.statusValue < 0.0f)) break;
            this.statusValue = 0.0f;
            break;
        }
        if (!oldShowStatus && this.showStatus) {
            this.oldStatusValue = this.statusValue;
        }
    }

    public void render(ForgeIngameGui gui, PoseStack stack, float partialTick, int width, int height) {
        float statusScale;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        IStamina stamina = IStamina.get((Player)player);
        Parkourability parkourability = Parkourability.get((Player)player);
        if (stamina == null || parkourability == null) {
            return;
        }
        if (ParCoolConfig.Client.Booleans.HideStaminaHUDWhenStaminaIsInfinite.get().booleanValue() && parkourability.getActionInfo().isStaminaInfinite(player.m_7500_() || player.m_5833_())) {
            return;
        }
        Window window = Minecraft.m_91087_().m_91268_();
        Position position = new Position((Position.Horizontal)((Object)ParCoolConfig.Client.AlignHorizontalStaminaHUD.get()), (Position.Vertical)((Object)ParCoolConfig.Client.AlignVerticalStaminaHUD.get()), ParCoolConfig.Client.Integers.HorizontalOffsetOfStaminaHUD.get(), ParCoolConfig.Client.Integers.VerticalOffsetOfStaminaHUD.get());
        int boxWidth = 91;
        int boxHeight = 17;
        Tuple<Integer, Integer> pos = position.calculate(91, 17, width, height);
        float staminaScale = (float)stamina.get() / (float)stamina.getActualMaxStamina();
        float f = statusScale = this.showStatus ? MathUtil.lerp(this.oldStatusValue, this.statusValue, partialTick) : 0.0f;
        if (staminaScale < 0.0f) {
            staminaScale = 0.0f;
        }
        if (staminaScale > 1.0f) {
            staminaScale = 1.0f;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)STAMINA);
        StaminaHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)0.0f, (int)93, (int)17, (int)128, (int)128);
        if (!stamina.isExhausted()) {
            StaminaHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)102.0f, (int)((int)Math.ceil(92.0f * statusScale)), (int)17, (int)128, (int)128);
            StaminaHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)85.0f, (int)(Math.round(16.0f + 69.0f * this.shadowScale) + 1), (int)12, (int)128, (int)128);
            StaminaHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)(17 * (this.renderGageType + 1)), (int)(Math.round(16.0f + 69.0f * staminaScale) + 1), (int)12, (int)128, (int)128);
        } else {
            StaminaHUD.m_93133_((PoseStack)stack, (int)((Integer)pos.m_14418_()), (int)((Integer)pos.m_14419_()), (float)0.0f, (float)68.0f, (int)(Math.round(16.0f + 69.0f * staminaScale) + 1), (int)17, (int)128, (int)128);
        }
        this.shadowScale = staminaScale - (staminaScale - this.shadowScale) / 1.1f;
    }
}

