/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.api.unstable.action.ParCoolActionEvent;
import com.alrex.parcool.client.animation.impl.ChargeJumpAnimator;
import com.alrex.parcool.client.animation.impl.JumpChargingAnimator;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ChargeJump
extends Action {
    public static final int JUMP_ANIMATION_TICK = 10;
    public static final int JUMP_MAX_CHARGE_TICK = 18;
    private int chargeTick = 0;
    private int lastChargeTick = 0;
    private int notChargeTick = 0;
    private int coolTimeTick = 0;
    private boolean started = false;

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean start = this.started;
        this.started = false;
        return start;
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return this.getDoingTick() < 10;
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Animation animation;
        this.coolTimeTick = 30;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.CHARGE_JUMP.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new ChargeJumpAnimator());
        }
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.CHARGE_JUMP.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new ChargeJumpAnimator());
        }
    }

    @Override
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        Animation animation;
        if (player instanceof LocalPlayer) {
            LocalPlayer cp = (LocalPlayer)player;
            if (!(!cp.m_20096_() || this.coolTimeTick > 0 || stamina.isExhausted() || !parkourability.getActionInfo().can(ChargeJump.class) || cp.m_20143_() || cp.m_20142_() || cp.m_20072_() || cp.f_108618_.f_108568_ || cp.f_108618_.f_108569_ || cp.f_108618_.f_108571_ || cp.f_108618_.f_108570_ || parkourability.get(Crawl.class).isDoing() || MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.TryToStartEvent(player, this)))) {
                if (cp.m_6144_()) {
                    ++this.chargeTick;
                    if (this.chargeTick > 18) {
                        this.chargeTick = 18;
                    }
                    this.lastChargeTick = this.chargeTick;
                    this.notChargeTick = 0;
                } else {
                    --this.chargeTick;
                    if (this.chargeTick < 0) {
                        this.chargeTick = 0;
                    }
                    ++this.notChargeTick;
                }
                if (this.isCharging()) {
                    Vec3 targetAngle = VectorUtil.fromYawDegree(player.f_20885_);
                    Vec3 currentAngle = VectorUtil.fromYawDegree(player.f_20883_);
                    double differenceAngle = Math.atan((currentAngle.m_7096_() * targetAngle.m_7094_() - targetAngle.m_7096_() * currentAngle.m_7094_()) / (targetAngle.m_7096_() * currentAngle.m_7096_() + targetAngle.m_7094_() * currentAngle.m_7094_()));
                    player.m_5618_((float)VectorUtil.toYawDegree(currentAngle.m_82524_((float)(-differenceAngle / 2.0))));
                }
            } else {
                if (this.coolTimeTick > 0) {
                    --this.coolTimeTick;
                }
                this.chargeTick = 0;
                ++this.notChargeTick;
            }
        }
        if (this.isCharging() && (animation = Animation.get(player)) != null && !animation.hasAnimator()) {
            animation.setAnimator(new JumpChargingAnimator());
        }
    }

    public void onJump(Player player, Parkourability parkourability, IStamina stamina) {
        double power = (double)this.chargeTick / 18.0;
        if (power >= 0.5) {
            this.started = true;
        } else {
            power = (double)this.lastChargeTick / 18.0;
            if (power > 0.5 && this.notChargeTick < 5) {
                this.started = true;
            }
        }
        if (this.started) {
            player.m_20256_(player.m_20184_().m_82520_(0.0, 0.16 * power, 0.0));
        }
    }

    public void onLand(Player player, Parkourability parkourability) {
        if (player.m_7578_() && player instanceof LocalPlayer) {
            LocalPlayer cp = (LocalPlayer)player;
            if (!(!parkourability.getActionInfo().can(ChargeJump.class) || this.coolTimeTick > 0 || cp.f_108618_.f_108568_ || cp.f_108618_.f_108569_ || cp.f_108618_.f_108571_ || cp.f_108618_.f_108570_ || parkourability.get(FastRun.class).getNotDashTick(parkourability.getAdditionalProperties()) >= 15)) {
                this.lastChargeTick = this.chargeTick = 23;
                this.notChargeTick = 0;
            }
        }
    }

    @Override
    public boolean wantsToShowStatusBar(LocalPlayer player, Parkourability parkourability) {
        return this.isCharging();
    }

    @Override
    public float getStatusValue(LocalPlayer player, Parkourability parkourability) {
        return (float)this.getChargingTick() / 18.0f;
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putInt(this.chargeTick);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.chargeTick = buffer.getInt();
    }

    public boolean isCharging() {
        return this.chargeTick > 0 && !this.isDoing();
    }

    public int getChargingTick() {
        return this.chargeTick;
    }
}

