/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.FastRunningAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.AdditionalProperties;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.HangDown;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FastRun
extends Action {
    private static final String FAST_RUNNING_MODIFIER_NAME = "parcool.modifier.fast_run";
    private static final UUID FAST_RUNNING_MODIFIER_UUID = UUID.randomUUID();
    private double speedModifier = 0.0;
    private boolean toggleStatus = false;
    private int lastDashTick = 0;

    public double getSpeedModifier(ActionInfo info) {
        return Math.min(info.getClientSetting().get(ParCoolConfig.Client.Doubles.FastRunSpeedModifier), info.getServerLimitation().get(ParCoolConfig.Server.Doubles.MaxFastRunSpeedModifier));
    }

    @Override
    public void onServerTick(Player player, Parkourability parkourability, IStamina stamina) {
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr == null) {
            return;
        }
        if (attr.m_22111_(FAST_RUNNING_MODIFIER_UUID) != null) {
            attr.m_22120_(FAST_RUNNING_MODIFIER_UUID);
        }
        if (this.isDoing()) {
            player.m_6858_(true);
            attr.m_22118_(new AttributeModifier(FAST_RUNNING_MODIFIER_UUID, FAST_RUNNING_MODIFIER_NAME, this.speedModifier / 100.0, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (player.m_7578_()) {
            if (ParCoolConfig.Client.FastRunControl.get() == ControlType.Toggle && parkourability.getAdditionalProperties().getSprintingTick() > 3) {
                if (KeyRecorder.keyFastRunning.isPressed()) {
                    this.toggleStatus = !this.toggleStatus;
                }
            } else {
                this.toggleStatus = false;
            }
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        return this.canContinue(player, parkourability, stamina);
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return !stamina.isExhausted() && !player.m_20072_() && player.m_20202_() == null && !player.m_21255_() && player.m_20142_() && !player.m_20143_() && !player.m_6069_() && !player.m_6144_() && !parkourability.get(Crawl.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && !parkourability.get(HangDown.class).isDoing() && (ParCoolConfig.Client.FastRunControl.get() == ControlType.PressKey && KeyBindings.getKeyFastRunning().m_90857_() || ParCoolConfig.Client.FastRunControl.get() == ControlType.Toggle && this.toggleStatus || ParCoolConfig.Client.FastRunControl.get() == ControlType.Auto);
    }

    @Override
    public void onWorkingTickInClient(Player player, Parkourability parkourability, IStamina stamina) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new FastRunningAnimator());
        }
    }

    @Override
    public void onStartInServer(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.speedModifier = this.getSpeedModifier(parkourability.getActionInfo());
    }

    @Override
    public void onStopInLocalClient(Player player) {
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        this.lastDashTick = this.getDashTick(parkourability.getAdditionalProperties());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canActWithRunning(Player player) {
        return ParCoolConfig.Client.Booleans.SubstituteSprintForFastRun.get() != false ? player.m_20142_() : this.isDoing();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDashTick(AdditionalProperties properties) {
        return ParCoolConfig.Client.Booleans.SubstituteSprintForFastRun.get() != false ? properties.getSprintingTick() : this.getDoingTick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getNotDashTick(AdditionalProperties properties) {
        return ParCoolConfig.Client.Booleans.SubstituteSprintForFastRun.get() != false ? properties.getNotSprintingTick() : this.getNotDoingTick();
    }

    public int getLastDashTick() {
        return this.lastDashTick;
    }

    public static enum ControlType {
        PressKey,
        Toggle,
        Auto;

    }
}

