/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.handlers;

import com.alrex.parcool.common.action.impl.BreakfallReady;
import com.alrex.parcool.common.action.impl.ChargeJump;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.network.StartBreakfallMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerFallHandler {
    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            parkourability = Parkourability.get((Player)player);
            if (parkourability == null) {
                return;
            }
            if (((Parkourability)parkourability).get(BreakfallReady.class).isDoing() && (((Parkourability)parkourability).getActionInfo().can(Tap.class) || ((Parkourability)parkourability).getActionInfo().can(Roll.class))) {
                boolean justTime = ((Parkourability)parkourability).get(BreakfallReady.class).getDoingTick() < 5;
                float distance = event.getDistance();
                if (distance > 2.0f) {
                    StartBreakfallMessage.send(player, justTime);
                }
                if (distance < 6.0f || justTime && distance < 8.0f) {
                    event.setCanceled(true);
                } else {
                    event.setDamageMultiplier(event.getDamageMultiplier() * (justTime ? 0.4f : 0.6f));
                }
            }
        } else {
            parkourability = event.getEntity();
            if (parkourability instanceof Player) {
                Player player = (Player)parkourability;
                if (!player.m_7578_()) {
                    return;
                }
                parkourability = Parkourability.get(player);
                if (parkourability == null) {
                    return;
                }
                if (((Parkourability)parkourability).getAdditionalProperties().getNotLandingTick() > 5 && event.getDistance() < 0.4f) {
                    ((Parkourability)parkourability).get(ChargeJump.class).onLand(player, (Parkourability)parkourability);
                }
            }
        }
    }
}

