/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.core.network;

import appeng.core.sync.network.TargetPoint;
import com.the9grounds.aeadditions.core.network.ClientPacketHandler;
import com.the9grounds.aeadditions.core.network.IPacketHandler;
import com.the9grounds.aeadditions.core.network.ServerPacketHandler;
import com.the9grounds.aeadditions.core.network.packet.BasePacket;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0006\u0010\u0016\u001a\u00020\u0013J\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020!H\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/the9grounds/aeadditions/core/network/NetworkManager;", "", "()V", "channel", "Lnet/minecraft/resources/ResourceLocation;", "getChannel", "()Lnet/minecraft/resources/ResourceLocation;", "setChannel", "(Lnet/minecraft/resources/ResourceLocation;)V", "clientHandler", "Lcom/the9grounds/aeadditions/core/network/IPacketHandler;", "getClientHandler", "()Lcom/the9grounds/aeadditions/core/network/IPacketHandler;", "setClientHandler", "(Lcom/the9grounds/aeadditions/core/network/IPacketHandler;)V", "serverHandler", "getServerHandler", "setServerHandler", "clientPacket", "", "event", "Lnet/minecraftforge/network/NetworkEvent$ServerCustomPayloadEvent;", "init", "sendTo", "message", "Lcom/the9grounds/aeadditions/core/network/packet/BasePacket;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "sendToAllAround", "point", "Lappeng/core/sync/network/TargetPoint;", "sendToServer", "serverPacket", "Lnet/minecraftforge/network/NetworkEvent$ClientCustomPayloadEvent;", "AEAdditions-1.18.2"})
public final class NetworkManager {
    @NotNull
    public static final NetworkManager INSTANCE;
    @Nullable
    private static ResourceLocation channel;
    @Nullable
    private static IPacketHandler clientHandler;
    @Nullable
    private static IPacketHandler serverHandler;

    private NetworkManager() {
    }

    @Nullable
    public final ResourceLocation getChannel() {
        return channel;
    }

    public final void setChannel(@Nullable ResourceLocation resourceLocation) {
        channel = resourceLocation;
    }

    @Nullable
    public final IPacketHandler getClientHandler() {
        return clientHandler;
    }

    public final void setClientHandler(@Nullable IPacketHandler iPacketHandler) {
        clientHandler = iPacketHandler;
    }

    @Nullable
    public final IPacketHandler getServerHandler() {
        return serverHandler;
    }

    public final void setServerHandler(@Nullable IPacketHandler iPacketHandler) {
        serverHandler = iPacketHandler;
    }

    public final void init() {
    }

    @SubscribeEvent
    public final void serverPacket(@NotNull NetworkEvent.ClientCustomPayloadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (serverHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
                PacketListener packetListener = ctx.getNetworkManager().m_129538_();
                if (packetListener == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.server.network.ServerGamePacketListenerImpl");
                }
                ServerGamePacketListenerImpl networkHandler = (ServerGamePacketListenerImpl)packetListener;
                ctx.setPacketHandled(true);
                ctx.enqueueWork(() -> NetworkManager.serverPacket$lambda-7(networkHandler, event));
            }
            catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public final void clientPacket(@NotNull NetworkEvent.ServerCustomPayloadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
            return;
        }
        if (clientHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
                PacketListener networkHandler = ctx.getNetworkManager().m_129538_();
                ctx.setPacketHandled(true);
                ctx.enqueueWork(() -> NetworkManager.clientPacket$lambda-8(networkHandler, event));
            }
            catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
                // empty catch block
            }
        }
    }

    public final void sendToAllAround(@NotNull BasePacket message, @NotNull TargetPoint point) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            Packet<?> packet = message.toPacket(NetworkDirection.PLAY_TO_CLIENT);
            server.m_6846_().m_11241_((Player)point.excluded, point.x, point.y, point.z, point.r2, point.level.m_46472_(), packet);
        }
    }

    public final void sendTo(@NotNull BasePacket message, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.f_8906_.m_141995_(message.toPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    public final void sendToServer(@NotNull BasePacket message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ClientPacketListener clientPacketListener = Minecraft.m_91087_().m_91403_();
        Intrinsics.checkNotNull((Object)clientPacketListener);
        clientPacketListener.m_104955_(message.toPacket(NetworkDirection.PLAY_TO_SERVER));
    }

    private static final String _init_$lambda-0() {
        return "1";
    }

    private static final boolean _init_$lambda-1(String it) {
        return true;
    }

    private static final boolean _init_$lambda-2(String it) {
        return true;
    }

    private static final ClientPacketHandler lambda-4$lambda-3() {
        return ClientPacketHandler.INSTANCE;
    }

    private static final Supplier _init_$lambda-4() {
        return NetworkManager::lambda-4$lambda-3;
    }

    private static final ClientPacketHandler lambda-6$lambda-5() {
        return null;
    }

    private static final Supplier _init_$lambda-6() {
        return NetworkManager::lambda-6$lambda-5;
    }

    private static final void serverPacket$lambda-7(ServerGamePacketListenerImpl $networkHandler, NetworkEvent.ClientCustomPayloadEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$networkHandler, (String)"$networkHandler");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        IPacketHandler iPacketHandler = serverHandler;
        Intrinsics.checkNotNull((Object)iPacketHandler);
        PacketListener packetListener = (PacketListener)$networkHandler;
        FriendlyByteBuf friendlyByteBuf = $event.getPayload();
        Intrinsics.checkNotNullExpressionValue((Object)friendlyByteBuf, (String)"event.payload");
        iPacketHandler.onPacketData(packetListener, friendlyByteBuf, (Player)$networkHandler.f_9743_);
    }

    private static final void clientPacket$lambda-8(PacketListener $networkHandler, NetworkEvent.ServerCustomPayloadEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        IPacketHandler iPacketHandler = clientHandler;
        Intrinsics.checkNotNull((Object)iPacketHandler);
        Intrinsics.checkNotNullExpressionValue((Object)$networkHandler, (String)"networkHandler");
        FriendlyByteBuf friendlyByteBuf = $event.getPayload();
        Intrinsics.checkNotNullExpressionValue((Object)friendlyByteBuf, (String)"event.payload");
        iPacketHandler.onPacketData($networkHandler, friendlyByteBuf, null);
    }

    static {
        IPacketHandler iPacketHandler;
        INSTANCE = new NetworkManager();
        channel = new ResourceLocation("ae2additions", "network_channel");
        EventNetworkChannel ec = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channel).networkProtocolVersion(NetworkManager::_init_$lambda-0).clientAcceptedVersions(NetworkManager::_init_$lambda-1).serverAcceptedVersions(NetworkManager::_init_$lambda-2).eventNetworkChannel();
        ec.registerObject((Object)INSTANCE);
        clientHandler = (IPacketHandler)DistExecutor.unsafeRunForDist(NetworkManager::_init_$lambda-4, NetworkManager::_init_$lambda-6);
        try {
            iPacketHandler = ServerPacketHandler.INSTANCE;
        }
        catch (Throwable e) {
            iPacketHandler = null;
        }
        serverHandler = iPacketHandler;
    }
}

