/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.core.network.packet;

import com.the9grounds.aeadditions.LoggerKt;
import com.the9grounds.aeadditions.core.network.packet.BasePacket;
import com.the9grounds.aeadditions.menu.MEWirelessTransceiverMenu;
import com.the9grounds.aeadditions.util.Channel;
import com.the9grounds.aeadditions.util.ChannelInfo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/the9grounds/aeadditions/core/network/packet/ChannelsPacket;", "Lcom/the9grounds/aeadditions/core/network/packet/BasePacket;", "packet", "Lnet/minecraft/network/FriendlyByteBuf;", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "channels", "", "Lcom/the9grounds/aeadditions/util/Channel;", "channelInfos", "Lcom/the9grounds/aeadditions/util/ChannelInfo;", "(Ljava/util/List;Ljava/util/List;)V", "", "getChannelInfos", "()Ljava/util/List;", "setChannelInfos", "(Ljava/util/List;)V", "getChannels", "setChannels", "clientPacketData", "", "player", "Lnet/minecraft/world/entity/player/Player;", "AEAdditions-1.18.2"})
public final class ChannelsPacket
extends BasePacket {
    @NotNull
    private List<ChannelInfo> channelInfos;
    @NotNull
    private List<Channel> channels;

    @NotNull
    public final List<ChannelInfo> getChannelInfos() {
        return this.channelInfos;
    }

    public final void setChannelInfos(@NotNull List<ChannelInfo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channelInfos = list;
    }

    @NotNull
    public final List<Channel> getChannels() {
        return this.channels;
    }

    public final void setChannels(@NotNull List<Channel> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.channels = list;
    }

    public ChannelsPacket(@NotNull FriendlyByteBuf packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this.channelInfos = new ArrayList();
        this.channels = new ArrayList();
        CompoundTag tag = packet.m_130260_();
        if (tag == null) {
            LoggerKt.getLogger().warn("Tag was null in ChannelsPacket");
            return;
        }
        CompoundTag channelInfosTag = tag.m_128469_("channelInfos");
        int channelInfosSize = channelInfosTag.m_128451_("size");
        int n = 0;
        while (n < channelInfosSize) {
            int i2 = n++;
            CompoundTag compoundTag = channelInfosTag.m_128469_(String.valueOf(i2));
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"channelInfosTag.getCompound(\"$i\")");
            ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
            if (clientLevel == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.world.level.Level");
            }
            ChannelInfo channelInfo = ChannelInfo.Companion.readFromNbt(compoundTag, (Level)clientLevel);
            this.channelInfos.add(i2, channelInfo);
        }
        CompoundTag channelsTag = tag.m_128469_("channels");
        int channelsSize = channelsTag.m_128451_("size");
        int n2 = 0;
        while (n2 < channelsSize) {
            int i3 = n2++;
            CompoundTag compoundTag = channelsTag.m_128469_(String.valueOf(i3));
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"channelsTag.getCompound(\"$i\")");
            ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
            if (clientLevel == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.world.level.Level");
            }
            Channel channel = Channel.Companion.loadFromNbt(compoundTag, this.channelInfos, (Level)clientLevel);
            if (channel == null) continue;
            this.channels.add(i3, channel);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ChannelsPacket(@NotNull List<Channel> channels, @NotNull List<ChannelInfo> channelInfos) {
        Intrinsics.checkNotNullParameter(channels, (String)"channels");
        Intrinsics.checkNotNullParameter(channelInfos, (String)"channelInfos");
        this.channelInfos = new ArrayList();
        this.channels = new ArrayList();
        FriendlyByteBuf data = this.getInitialData();
        int channelsSize = channels.size();
        int channelInfoSize = channelInfos.size();
        CompoundTag nbt = new CompoundTag();
        CompoundTag channelsTag = new CompoundTag();
        channelsTag.m_128405_("size", channelsSize);
        Iterable $this$forEachIndexed$iv = channels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void channel;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Channel channel2 = (Channel)item$iv;
            int index = n;
            boolean bl = false;
            CompoundTag tag = channel.saveToNbt();
            channelsTag.m_128365_(String.valueOf(index), (Tag)tag);
        }
        CompoundTag channelInfoTag = new CompoundTag();
        channelInfoTag.m_128405_("size", channelInfoSize);
        Iterable $this$forEachIndexed$iv2 = channelInfos;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv2) {
            void channelInfo;
            int n = index$iv2;
            index$iv2 = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ChannelInfo index = (ChannelInfo)item$iv;
            int index2 = n;
            boolean bl = false;
            CompoundTag tag = channelInfo.saveToNbt();
            channelInfoTag.m_128365_(String.valueOf(index2), (Tag)tag);
        }
        nbt.m_128365_("channels", (Tag)channelsTag);
        nbt.m_128365_("channelInfos", (Tag)channelInfoTag);
        data.m_130079_(nbt);
        this.configureWrite(data);
    }

    @Override
    public void clientPacketData(@Nullable Player player) {
        Player player2 = player;
        Intrinsics.checkNotNull((Object)player2);
        AbstractContainerMenu containerMenu = player2.f_36096_;
        if (containerMenu instanceof MEWirelessTransceiverMenu) {
            ((MEWirelessTransceiverMenu)containerMenu).receiveChannelData(this.channelInfos, this.channels);
        }
    }
}

