/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.hooks.AEToolItem;
import appeng.items.contents.CellConfig;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import com.the9grounds.aeadditions.item.storage.DiskCellWithoutMod;
import io.github.projectet.ae2things.storage.DISKCellHandler;
import io.github.projectet.ae2things.storage.DISKCellInventory;
import io.github.projectet.ae2things.storage.IDISKCellItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ6\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\"\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001c2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0012\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010)\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010*\u001a\u00020\fJ\u0014\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010-\u001a\u00020\u001aH\u0016J\b\u00100\u001a\u00020\u000eH\u0016J\b\u00101\u001a\u00020\u0007H\u0016J\u0012\u00102\u001a\u0002032\b\u0010-\u001a\u0004\u0018\u00010\u001aH\u0016J\u001c\u00104\u001a\u00020#2\b\u0010(\u001a\u0004\u0018\u00010\u001a2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0012\u00107\u001a\u00020#2\b\u0010-\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020:H\u0016J\u0018\u0010;\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020/H\u0016J*\u0010=\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010>2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\b\u0010?\u001a\u0004\u0018\u00010@H\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006A"}, d2={"Lcom/the9grounds/aeadditions/item/storage/DiskCell;", "Lcom/the9grounds/aeadditions/item/storage/DiskCellWithoutMod;", "Lio/github/projectet/ae2things/storage/IDISKCellItem;", "Lappeng/hooks/AEToolItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "_keyType", "Lappeng/api/stacks/AEKeyType;", "component", "Lnet/minecraft/world/level/ItemLike;", "housing", "kilobytes", "", "_idleDrain", "", "(Lnet/minecraft/world/item/Item$Properties;Lappeng/api/stacks/AEKeyType;Lnet/minecraft/world/level/ItemLike;Lnet/minecraft/world/level/ItemLike;ID)V", "get_idleDrain", "()D", "getComponent", "()Lnet/minecraft/world/level/ItemLike;", "getHousing", "getKilobytes", "()I", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "world", "Lnet/minecraft/world/level/Level;", "tooltip", "", "Lnet/minecraft/network/chat/Component;", "context", "Lnet/minecraft/world/item/TooltipFlag;", "disassembleDrive", "", "level", "player", "Lnet/minecraft/world/entity/player/Player;", "getBytes", "cellItem", "getColor", "tintIndex", "getConfigInventory", "Lappeng/util/ConfigInventory;", "is", "getFuzzyMode", "Lappeng/api/config/FuzzyMode;", "getIdleDrain", "getKeyType", "getUpgrades", "Lappeng/api/upgrades/IUpgradeInventory;", "isBlackListed", "requestedAddition", "Lappeng/api/stacks/AEKey;", "isEditable", "onItemUseFirst", "Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/item/context/UseOnContext;", "setFuzzyMode", "fzMode", "use", "Lnet/minecraft/world/InteractionResultHolder;", "hand", "Lnet/minecraft/world/InteractionHand;", "AEAdditions-1.18.2"})
public final class DiskCell
extends DiskCellWithoutMod
implements IDISKCellItem,
AEToolItem {
    @NotNull
    private final AEKeyType _keyType;
    @NotNull
    private final ItemLike component;
    @NotNull
    private final ItemLike housing;
    private final int kilobytes;
    private final double _idleDrain;

    public DiskCell(@NotNull Item.Properties properties, @NotNull AEKeyType _keyType, @NotNull ItemLike component, @NotNull ItemLike housing, int kilobytes, double _idleDrain) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)_keyType, (String)"_keyType");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)housing, (String)"housing");
        super(properties);
        this._keyType = _keyType;
        this.component = component;
        this.housing = housing;
        this.kilobytes = kilobytes;
        this._idleDrain = _idleDrain;
    }

    @NotNull
    public final ItemLike getComponent() {
        return this.component;
    }

    @NotNull
    public final ItemLike getHousing() {
        return this.housing;
    }

    public final int getKilobytes() {
        return this.kilobytes;
    }

    public final double get_idleDrain() {
        return this._idleDrain;
    }

    @NotNull
    public AEKeyType getKeyType() {
        return this._keyType;
    }

    public boolean isBlackListed(@Nullable ItemStack cellItem, @Nullable AEKey requestedAddition) {
        if (requestedAddition instanceof AEItemKey) {
            return super.isBlackListed(cellItem, requestedAddition);
        }
        return false;
    }

    public int getBytes(@Nullable ItemStack cellItem) {
        return this.kilobytes * 1024;
    }

    public double getIdleDrain() {
        return this._idleDrain;
    }

    public boolean isEditable(@Nullable ItemStack is) {
        return true;
    }

    @Nullable
    public ConfigInventory getConfigInventory(@Nullable ItemStack is) {
        return CellConfig.create((AEKeyFilter)this.getKeyType().filter(), (ItemStack)is);
    }

    @Nullable
    public FuzzyMode getFuzzyMode(@NotNull ItemStack is) {
        FuzzyMode fuzzyMode;
        Intrinsics.checkNotNullParameter((Object)is, (String)"is");
        String fz = is.m_41784_().m_128461_("FuzzyMode");
        Intrinsics.checkNotNullExpressionValue((Object)fz, (String)"fz");
        if (((CharSequence)fz).length() == 0) {
            fuzzyMode = FuzzyMode.IGNORE_ALL;
        } else {
            FuzzyMode fuzzyMode2;
            try {
                fuzzyMode2 = FuzzyMode.valueOf((String)fz);
            }
            catch (Throwable t) {
                fuzzyMode2 = FuzzyMode.IGNORE_ALL;
            }
            fuzzyMode = fuzzyMode2;
        }
        return fuzzyMode;
    }

    public void setFuzzyMode(@NotNull ItemStack is, @NotNull FuzzyMode fzMode) {
        Intrinsics.checkNotNullParameter((Object)is, (String)"is");
        Intrinsics.checkNotNullParameter((Object)fzMode, (String)"fzMode");
        is.m_41784_().m_128359_("FuzzyMode", fzMode.name());
    }

    @Nullable
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @Nullable InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.m_21120_(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"player.getItemInHand(hand)");
        this.disassembleDrive(itemStack, level, player);
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)player.m_21120_(hand));
    }

    @NotNull
    public IUpgradeInventory getUpgrades(@Nullable ItemStack is) {
        IUpgradeInventory iUpgradeInventory = UpgradeInventories.forItem((ItemStack)is, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)iUpgradeInventory, (String)"forItem(`is`, 2)");
        return iUpgradeInventory;
    }

    private final boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            KeyCounter list;
            if (level.m_5776_()) {
                return false;
            }
            Player player2 = player;
            Intrinsics.checkNotNull((Object)player2);
            Inventory playerInventory = player2.m_150109_();
            StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (inv != null && Intrinsics.areEqual((Object)playerInventory.m_36056_(), (Object)stack) && (list = inv.getAvailableStacks()).isEmpty()) {
                playerInventory.m_6836_(playerInventory.f_35977_, ItemStack.f_41583_);
                playerInventory.m_150079_(new ItemStack(this.component));
                for (ItemStack upgrade : this.getUpgrades(stack)) {
                    playerInventory.m_150079_(upgrade);
                }
                playerInventory.m_150079_(new ItemStack(this.housing));
                return true;
            }
        }
        return false;
    }

    @Nullable
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, @NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.m_43725_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"context.level");
        return this.disassembleDrive(stack, level, context.m_43723_()) ? InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_()) : InteractionResult.PASS;
    }

    public void m_7373_(@Nullable ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @Nullable TooltipFlag context) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC};
        tooltip.add((Component)new TextComponent("Deep Item Storage disK - Storage for dummies").m_130944_(chatFormattingArray));
        this.addCellInformationToTooltip(stack, tooltip);
    }

    public final int getColor(@Nullable ItemStack stack, int tintIndex) {
        int n;
        if (tintIndex == 1) {
            DISKCellInventory cellInv = DISKCellHandler.INSTANCE.getCellInventory(stack, null);
            CellState cellStatus = cellInv != null ? cellInv.getClientStatus() : CellState.EMPTY;
            n = cellStatus.getStateColor();
        } else {
            n = 0xFFFFFF;
        }
        return n;
    }
}

