/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.just_enough_beacons.jei.beaconpayment;

import com.cerbon.just_enough_beacons.jei.beaconpayment.BeaconPaymentRecipe;
import com.cerbon.just_enough_beacons.util.JEBConstants;
import com.cerbon.just_enough_beacons.util.JEBRecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BeaconPaymentCategory
implements IRecipeCategory<BeaconPaymentRecipe> {
    private final IGuiHelper guiHelper;

    public BeaconPaymentCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public ResourceLocation getUid() {
        return null;
    }

    public Class<? extends BeaconPaymentRecipe> getRecipeClass() {
        return BeaconPaymentRecipe.class;
    }

    @NotNull
    public RecipeType<BeaconPaymentRecipe> getRecipeType() {
        return JEBRecipeTypes.BEACON_PAYMENT;
    }

    @NotNull
    public Component getTitle() {
        return new TranslatableComponent("category.beacon_payments");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(JEBConstants.BACKGROUND, 0, 0, 128, 128);
    }

    @NotNull
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50273_));
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull BeaconPaymentRecipe recipe, @NotNull IFocusGroup focuses) {
        int xPos = 2;
        int yPos = 53;
        int count = recipe.getBeaconPaymentSublist().size();
        int y = 0;
        while ((double)y < Math.ceil((double)count / 7.0)) {
            int index;
            for (int x = 0; x < 7 && (index = 7 * y + x) < count; ++x) {
                builder.addSlot(RecipeIngredientRole.CATALYST, xPos + 18 * x, yPos + 18 * y).addItemStack(recipe.getBeaconPaymentSublist().get(index));
            }
            ++y;
        }
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 55, 5).addItemStack(new ItemStack((ItemLike)Blocks.f_50273_));
    }
}

