/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core;

import com.almostreliable.lootjs.loot.LootFunctionsContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public class LootEntry
implements LootFunctionsContainer<LootEntry>,
Function<LootContext, ItemStack> {
    private final ItemStack itemStack;
    private final List<LootItemFunction> postModifications = new ArrayList<LootItemFunction>();
    private int weight = 1;

    public LootEntry(Item item) {
        this.itemStack = new ItemStack((ItemLike)item);
    }

    public LootEntry(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public ItemStack apply(LootContext context) {
        if (this.itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = this.itemStack.m_41777_();
        for (LootItemFunction lootItemFunction : this.postModifications) {
            result = (ItemStack)lootItemFunction.apply((Object)result, (Object)context);
        }
        return result;
    }

    @Override
    public LootEntry addFunction(LootItemFunction lootItemFunction) {
        this.postModifications.add(lootItemFunction);
        return this;
    }

    public boolean hasWeight() {
        return this.weight >= 1;
    }

    public int getWeight() {
        return this.weight;
    }

    public LootEntry withWeight(int weight) {
        this.weight = Math.max(1, weight);
        return this;
    }

    public LootEntry withChance(int chance) {
        return this.withWeight(chance);
    }
}

