/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.gametest.conditions;

import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.forge.gametest.GameTestUtils;
import com.almostreliable.lootjs.loot.condition.MatchEquipmentSlot;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="lootjs")
@PrefixGameTestTemplate(value=false)
public class MatchEquipmentSlotTest {
    @GameTest(m_177046_="empty_test_structure")
    public void hasDiamondInHand(GameTestHelper helper) {
        LootContext ctx = this.basicSetup(helper);
        MatchEquipmentSlot check = new MatchEquipmentSlot(EquipmentSlot.MAINHAND, itemStack -> itemStack.m_41720_() == Items.f_42415_);
        helper.m_177279_(() -> GameTestUtils.assertTrue(helper, check.test(ctx), "MatchEquipmentSlot check should pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void hasStickInOffHand(GameTestHelper helper) {
        LootContext ctx = this.basicSetup(helper);
        MatchEquipmentSlot check = new MatchEquipmentSlot(EquipmentSlot.OFFHAND, itemStack -> itemStack.m_41720_() == Items.f_42398_);
        helper.m_177279_(() -> GameTestUtils.assertTrue(helper, check.test(ctx), "MatchEquipmentSlot check should pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void matchBoots(GameTestHelper helper) {
        LootContext ctx = this.basicSetup(helper);
        MatchEquipmentSlot check = new MatchEquipmentSlot(EquipmentSlot.FEET, itemStack -> itemStack.m_41720_() == Items.f_42475_);
        helper.m_177279_(() -> GameTestUtils.assertTrue(helper, check.test(ctx), "MatchEquipmentSlot check should pass"));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void failMatchMainHand(GameTestHelper helper) {
        LootContext ctx = this.basicSetup(helper);
        MatchEquipmentSlot check = new MatchEquipmentSlot(EquipmentSlot.MAINHAND, ItemFilter.SWORD);
        helper.m_177279_(() -> GameTestUtils.assertFalse(helper, check.test(ctx), "MatchEquipmentSlot check should fail"));
    }

    public LootContext basicSetup(GameTestHelper helper) {
        ServerPlayer player = new ServerPlayer(helper.m_177100_().m_142572_(), helper.m_177100_(), new GameProfile(UUID.randomUUID(), "test-mock-server-player")){

            public boolean m_5833_() {
                return false;
            }

            public boolean m_7500_() {
                return true;
            }
        };
        LootContext.Builder builder = new LootContext.Builder(helper.m_177100_()).m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)player);
        player.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42415_));
        player.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42398_));
        player.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42472_));
        player.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42473_));
        player.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42474_));
        player.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42475_));
        return builder.m_78975_(LootContextParamSets.f_81411_);
    }
}

