/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.gametest.conditions;

import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootContextType;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.forge.gametest.GameTestUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="lootjs")
@PrefixGameTestTemplate(value=false)
public class ParamSetTest {
    private static final Vec3 TEST_POS = new Vec3(0.0, 0.0, 0.0);

    @GameTest(m_177046_="empty_test_structure")
    public void chest(GameTestHelper helper) {
        LootContext ctx = GameTestUtils.chestContext(helper.m_177100_(), TEST_POS, null);
        helper.m_177279_(() -> GameTestUtils.assertEquals(helper, (Object)((ILootContextData)ctx.m_165124_(LootJSParamSets.DATA)).getLootContextType(), (Object)LootContextType.CHEST));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void entity(GameTestHelper helper) {
        Cow cow = (Cow)GameTestUtils.simpleEntity(EntityType.f_20557_, helper.m_177100_(), new BlockPos(TEST_POS));
        LootContext ctx = cow.m_7771_(true, DamageSource.f_19315_).m_78975_(LootContextParamSets.f_81415_);
        helper.m_177279_(() -> GameTestUtils.assertEquals(helper, (Object)((ILootContextData)ctx.m_165124_(LootJSParamSets.DATA)).getLootContextType(), (Object)LootContextType.ENTITY));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void block(GameTestHelper helper) {
        LootContext ctx = new LootContext.Builder(helper.m_177100_()).m_78977_(helper.m_177100_().m_5822_()).m_78972_(LootContextParams.f_81460_, (Object)TEST_POS).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78972_(LootContextParams.f_81461_, (Object)helper.m_177100_().m_8055_(new BlockPos(TEST_POS))).m_78975_(LootContextParamSets.f_81411_);
        helper.m_177279_(() -> GameTestUtils.assertEquals(helper, (Object)((ILootContextData)ctx.m_165124_(LootJSParamSets.DATA)).getLootContextType(), (Object)LootContextType.CHEST));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void fishing(GameTestHelper helper) {
        Player player = helper.m_177368_();
        FishingHook martin = new FishingHook(player, (Level)helper.m_177100_(), 0, 0);
        LootContext.Builder builder = new LootContext.Builder(helper.m_177100_()).m_78972_(LootContextParams.f_81460_, (Object)TEST_POS).m_78972_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_78972_(LootContextParams.f_81455_, (Object)martin).m_78984_(LootContextParams.f_81458_, (Object)player).m_78977_(helper.m_177100_().m_5822_()).m_78963_(0.0f);
        LootContext ctx = builder.m_78975_(LootContextParamSets.f_81414_);
        helper.m_177279_(() -> GameTestUtils.assertEquals(helper, (Object)((ILootContextData)ctx.m_165124_(LootJSParamSets.DATA)).getLootContextType(), (Object)LootContextType.FISHING));
    }

    @GameTest(m_177046_="empty_test_structure")
    public void unknown(GameTestHelper helper) {
        LootContext ctx = GameTestUtils.unknownContext(helper.m_177100_(), TEST_POS);
        helper.m_177279_(() -> GameTestUtils.assertEquals(helper, (Object)((ILootContextData)ctx.m_165124_(LootJSParamSets.DATA)).getLootContextType(), (Object)LootContextType.UNKNOWN));
    }
}

