/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.kube;

import com.almostreliable.lootjs.LootModificationsAPI;
import com.almostreliable.lootjs.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.kube.LootJSPlugin;
import com.almostreliable.lootjs.kube.LootModificationEventJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class LootModificationForgeEventJS
extends LootModificationEventJS {
    private final List<ResourceLocation> originalLocations;
    private final Set<ResourceLocation> locationsToRemove = new HashSet<ResourceLocation>();

    public LootModificationForgeEventJS(ArrayList<ResourceLocation> originalLocations) {
        this.originalLocations = originalLocations;
    }

    public List<String> getGlobalModifiers() {
        return this.originalLocations.stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public void disableLootModification(ResourceLocationFilter ... filters) {
        if (filters.length == 0) {
            throw new IllegalArgumentException("No loot table were given.");
        }
        LootModificationsAPI.FILTERS.addAll(Arrays.asList(filters));
    }

    public void removeGlobalModifier(String ... locationOrModIds) {
        HashSet<String> modIds = new HashSet<String>();
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>();
        for (String locationOrModId : locationOrModIds) {
            if (locationOrModId.startsWith("@")) {
                modIds.add(locationOrModId.substring(1));
                continue;
            }
            locations.add(new ResourceLocation(locationOrModId));
        }
        Set collectedByModIds = this.originalLocations.stream().filter(rl -> modIds.contains(rl.m_135827_())).collect(Collectors.toSet());
        Set collectedByLocations = this.originalLocations.stream().filter(locations::contains).collect(Collectors.toSet());
        this.locationsToRemove.addAll(collectedByModIds);
        this.locationsToRemove.addAll(collectedByLocations);
    }

    @Override
    protected void afterPosted(boolean result) {
        super.afterPosted(result);
        if (LootJSPlugin.eventsAreDisabled()) {
            return;
        }
        this.originalLocations.removeIf(this.locationsToRemove::contains);
    }
}

