/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube;

import com.almostreliable.lootjs.LootJSPlatform;
import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootContextType;
import com.almostreliable.lootjs.core.LootEntry;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.util.LootContextUtils;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.player.PlayerJS;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class LootContextJS {
    protected final LootContext context;
    private final ILootContextData data;
    private BlockContainerJS cachedBlockContainer;

    public LootContextJS(LootContext context) {
        this.context = context;
        this.data = (ILootContextData)context.m_78953_(LootJSParamSets.DATA);
        assert (this.data != null);
    }

    public ResourceLocation getLootTableId() {
        return LootJSPlatform.INSTANCE.getQueriedLootTableId(this.context);
    }

    public LootContextType getType() {
        return this.data.getLootContextType();
    }

    public boolean isCanceled() {
        return this.data.isCanceled();
    }

    public void cancel() {
        this.data.setCanceled(true);
    }

    public Map<String, Object> getCustomData() {
        return this.data.getCustomData();
    }

    public Vec3 getPosition() {
        Vec3 vec = (Vec3)this.context.m_78953_(LootContextParams.f_81460_);
        if (vec != null) {
            return vec;
        }
        Entity entity = (Entity)this.context.m_78953_(LootContextParams.f_81455_);
        if (entity != null) {
            return entity.m_20182_();
        }
        ConsoleJS.SERVER.warn((Object)"No position found. This should not happen");
        return Vec3.f_82478_;
    }

    public BlockPos getBlockPos() {
        Vec3 position = this.getPosition();
        return new BlockPos(position.f_82479_, position.f_82480_, position.f_82481_);
    }

    @Nullable
    public EntityJS getEntity() {
        return this.getLevel().getEntity((Entity)this.context.m_78953_(LootContextParams.f_81455_));
    }

    @Nullable
    public EntityJS getKillerEntity() {
        return this.getLevel().getEntity((Entity)this.context.m_78953_(LootContextParams.f_81458_));
    }

    @Nullable
    public PlayerJS<?> getPlayer() {
        return this.getLevel().getPlayer((Entity)LootContextUtils.getPlayerOrNull(this.context));
    }

    @Nullable
    public DamageSource getDamageSource() {
        return (DamageSource)this.context.m_78953_(LootContextParams.f_81457_);
    }

    public ItemStackJS getTool() {
        ItemStack tool = (ItemStack)this.context.m_78953_(LootContextParams.f_81463_);
        if (tool == null) {
            return ItemStackJS.EMPTY;
        }
        return new ItemStackJS(tool);
    }

    @Nullable
    public BlockContainerJS getDestroyedBlock() {
        if (this.cachedBlockContainer == null) {
            final BlockState blockStateInContext = (BlockState)this.context.m_78953_(LootContextParams.f_81461_);
            if (blockStateInContext == null) {
                return null;
            }
            BlockPos blockPos = this.getBlockPos();
            this.cachedBlockContainer = new BlockContainerJS((Level)this.context.m_78952_(), blockPos){

                public BlockState getBlockState() {
                    return blockStateInContext;
                }
            };
        }
        return this.cachedBlockContainer;
    }

    public boolean isExploded() {
        return this.context.m_78936_(LootContextParams.f_81464_);
    }

    public float getExplosionRadius() {
        Float f = (Float)this.context.m_78953_(LootContextParams.f_81464_);
        return f != null ? f.floatValue() : 0.0f;
    }

    public LevelJS getLevel() {
        return UtilsJS.getLevel((Level)this.context.m_78952_());
    }

    @Nullable
    public ServerJS getServer() {
        return this.getLevel().getServer();
    }

    public float getLuck() {
        return this.context.m_78945_();
    }

    public int getLooting() {
        Entity killer = (Entity)this.context.m_78953_(LootContextParams.f_81458_);
        if (killer instanceof LivingEntity) {
            LivingEntity asLiving = (LivingEntity)killer;
            return EnchantmentHelper.m_44930_((LivingEntity)asLiving);
        }
        return 0;
    }

    public Random getRandom() {
        return this.context.m_78933_();
    }

    public LootContext getVanillaContext() {
        return this.context;
    }

    public int lootSize() {
        return this.data.getGeneratedLoot().size();
    }

    public void addLoot(LootEntry lootEntry) {
        ItemStack item = lootEntry.apply(this.context);
        this.data.getGeneratedLoot().add(item);
    }

    public void removeLoot(ItemFilter itemFilter) {
        this.data.getGeneratedLoot().removeIf(itemFilter);
    }

    public List<ItemStackJS> findLoot(ItemFilter itemFilter) {
        return this.data.getGeneratedLoot().stream().filter(itemFilter).map(ItemStackJS::of).collect(Collectors.toList());
    }

    public boolean hasLoot(ItemFilter ingredient) {
        return !this.findLoot(ingredient).isEmpty();
    }

    public void forEachLoot(Consumer<ItemStackJS> action) {
        this.data.getGeneratedLoot().forEach(itemStack -> action.accept(ItemStackJS.of((Object)itemStack)));
    }
}

