/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube;

import com.almostreliable.lootjs.LootModificationsAPI;
import com.almostreliable.lootjs.core.ILootAction;
import com.almostreliable.lootjs.core.ILootHandler;
import com.almostreliable.lootjs.core.LootContextType;
import com.almostreliable.lootjs.core.LootModificationByBlock;
import com.almostreliable.lootjs.core.LootModificationByEntity;
import com.almostreliable.lootjs.core.LootModificationByTable;
import com.almostreliable.lootjs.core.LootModificationByType;
import com.almostreliable.lootjs.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.kube.LootJSPlugin;
import com.almostreliable.lootjs.kube.builder.LootActionsBuilderJS;
import com.almostreliable.lootjs.util.Utils;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EntityType;
import org.apache.commons.lang3.StringUtils;

public abstract class LootModificationEventJS
extends EventJS {
    private final List<Supplier<ILootAction>> modifierSuppliers = new ArrayList<Supplier<ILootAction>>();

    public void enableLogging() {
        LootModificationsAPI.LOOT_MODIFICATION_LOGGING = true;
    }

    public LootActionsBuilderJS addLootTableModifier(ResourceLocationFilter ... filters) {
        if (filters.length == 0) {
            throw new IllegalArgumentException("No loot table were given.");
        }
        LootActionsBuilderJS builder = new LootActionsBuilderJS();
        this.modifierSuppliers.add(() -> {
            List<ILootHandler> actions = builder.getHandlers();
            String logName = builder.getLogName(Utils.quote("LootTables", Arrays.asList(filters)));
            return new LootModificationByTable(logName, filters, new ArrayList<ILootHandler>(actions));
        });
        return builder;
    }

    public LootActionsBuilderJS addLootTypeModifier(LootContextType ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("No loot type were given.");
        }
        LootActionsBuilderJS builder = new LootActionsBuilderJS();
        this.modifierSuppliers.add(() -> {
            List<ILootHandler> actions = builder.getHandlers();
            String logName = builder.getLogName(Utils.quote("Types", Arrays.asList(types)));
            return new LootModificationByType(logName, new ArrayList<LootContextType>(Arrays.asList(types)), new ArrayList<ILootHandler>(actions));
        });
        return builder;
    }

    public LootActionsBuilderJS addBlockLootModifier(Object o) {
        Preconditions.checkNotNull((Object)o);
        BlockStatePredicate blockStatePredicate = BlockStatePredicate.of((Object)o);
        LootActionsBuilderJS builder = new LootActionsBuilderJS();
        this.modifierSuppliers.add(() -> {
            List<ILootHandler> actions = builder.getHandlers();
            String logName = builder.getLogName("BlocksPredicate for: " + StringUtils.abbreviate((String)o.toString(), (int)50));
            return new LootModificationByBlock(logName, arg_0 -> ((BlockStatePredicate)blockStatePredicate).test(arg_0), new ArrayList<ILootHandler>(actions));
        });
        return builder;
    }

    public LootActionsBuilderJS addEntityLootModifier(EntityType<?> ... entities) {
        HashSet set = new HashSet();
        Arrays.stream(entities).filter(Objects::nonNull).forEach(set::add);
        if (set.isEmpty()) {
            throw new IllegalArgumentException("No valid entities given.");
        }
        LootActionsBuilderJS builder = new LootActionsBuilderJS();
        this.modifierSuppliers.add(() -> {
            List<ILootHandler> actions = builder.getHandlers();
            String logName = builder.getLogName(Utils.quote("Entities", set.stream().map(arg_0 -> ((DefaultedRegistry)Registry.f_122826_).m_7981_(arg_0)).collect(Collectors.toList())));
            return new LootModificationByEntity(logName, set, new ArrayList<ILootHandler>(actions));
        });
        return builder;
    }

    public void disableWitherStarDrop() {
        LootModificationsAPI.DISABLE_WITHER_DROPPING_NETHER_STAR = true;
    }

    public void disableCreeperHeadDrop() {
        LootModificationsAPI.DISABLE_CREEPER_DROPPING_HEAD = true;
    }

    public void disableSkeletonHeadDrop() {
        LootModificationsAPI.DISABLE_SKELETON_DROPPING_HEAD = true;
    }

    public void disableZombieHeadDrop() {
        LootModificationsAPI.DISABLE_ZOMBIE_DROPPING_HEAD = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterPosted(boolean result) {
        super.afterPosted(result);
        if (LootJSPlugin.eventsAreDisabled()) {
            return;
        }
        try {
            for (Supplier<ILootAction> modifierSupplier : this.modifierSuppliers) {
                LootModificationsAPI.addModification(modifierSupplier.get());
            }
        }
        catch (Exception exception) {
            ConsoleJS.SERVER.error((Object)exception);
        }
        finally {
            if (CommonProperties.get().announceReload && ServerJS.instance != null && !CommonProperties.get().hideServerScriptErrors && !ScriptType.SERVER.errors.isEmpty()) {
                ServerJS.instance.tell((Component)new TextComponent("LootJS Errors found! [" + ScriptType.SERVER.errors.size() + "]! Run '/kubejs errors' for more info").m_130940_(ChatFormatting.DARK_RED));
            }
        }
    }
}

