/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.core.ILootAction;
import com.almostreliable.lootjs.core.LootEntry;
import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.loot.action.AddLootAction;
import com.almostreliable.lootjs.loot.action.DropExperienceAction;
import com.almostreliable.lootjs.loot.action.ExplodeAction;
import com.almostreliable.lootjs.loot.action.LightningStrikeAction;
import com.almostreliable.lootjs.loot.action.ModifyLootAction;
import com.almostreliable.lootjs.loot.action.RemoveLootAction;
import com.almostreliable.lootjs.loot.action.ReplaceLootAction;
import com.almostreliable.lootjs.loot.action.WeightedAddLootAction;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public interface LootActionsContainer<A extends LootActionsContainer<?>> {
    default public A addLoot(LootEntry[] itemStacks) {
        return this.addAction(new AddLootAction(itemStacks));
    }

    default public A addWeightedLoot(NumberProvider numberProvider, boolean allowDuplicateLoot, LootEntry[] poolEntries) {
        SimpleWeightedRandomList.Builder weightedListBuilder = SimpleWeightedRandomList.m_146263_();
        for (LootEntry poolEntry : poolEntries) {
            weightedListBuilder.m_146271_((Object)poolEntry, poolEntry.getWeight());
        }
        return this.addAction(new WeightedAddLootAction(numberProvider, (SimpleWeightedRandomList<LootEntry>)weightedListBuilder.m_146270_(), allowDuplicateLoot));
    }

    default public A addWeightedLoot(NumberProvider numberProvider, LootEntry[] poolEntries) {
        return this.addWeightedLoot(numberProvider, true, poolEntries);
    }

    default public A addWeightedLoot(LootEntry[] poolEntries) {
        return this.addWeightedLoot((NumberProvider)ConstantValue.m_165692_((float)1.0f), true, poolEntries);
    }

    default public A removeLoot(ItemFilter filter) {
        return this.addAction(new RemoveLootAction(filter));
    }

    default public A replaceLoot(ItemFilter filter, LootEntry lootEntry) {
        return this.replaceLoot(filter, lootEntry, false);
    }

    default public A replaceLoot(ItemFilter filter, LootEntry lootEntry, boolean preserveCount) {
        return this.addAction(new ReplaceLootAction(filter, lootEntry, preserveCount));
    }

    default public A modifyLoot(ItemFilter filter, ModifyLootAction.Callback callback) {
        return this.addAction(new ModifyLootAction(filter, callback));
    }

    default public A triggerExplosion(float radius, boolean destroy, boolean fire) {
        Explosion.BlockInteraction mode = destroy ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
        return this.addAction(new ExplodeAction(radius, mode, fire));
    }

    default public A triggerLightningStrike(boolean shouldDamage) {
        return this.addAction(new LightningStrikeAction(shouldDamage));
    }

    default public A dropExperience(int amount) {
        return this.addAction(new DropExperienceAction(amount));
    }

    public A addAction(ILootAction var1);
}

