/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.loot.AddAttributesFunction;
import com.almostreliable.lootjs.loot.action.LootItemFunctionWrapperAction;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetLoreFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public interface LootFunctionsContainer<F extends LootFunctionsContainer<?>> {
    default public F enchantRandomly() {
        return this.enchantRandomly(new Enchantment[0]);
    }

    default public F enchantRandomly(Enchantment[] enchantments) {
        EnchantRandomlyFunction.Builder enchantRandomlyFunctionBuilder = EnchantRandomlyFunction.m_165191_();
        for (Enchantment enchantment : enchantments) {
            enchantRandomlyFunctionBuilder.m_80444_(enchantment);
        }
        return this.addFunction((LootItemFunction.Builder)enchantRandomlyFunctionBuilder);
    }

    default public F enchantWithLevels(NumberProvider numberProvider) {
        return this.enchantWithLevels(numberProvider, true);
    }

    default public F enchantWithLevels(NumberProvider numberProvider, boolean allowTreasure) {
        EnchantWithLevelsFunction.Builder ewlBuilder = EnchantWithLevelsFunction.m_165196_((NumberProvider)numberProvider);
        if (allowTreasure) {
            ewlBuilder.m_80499_();
        }
        return this.addFunction((LootItemFunction.Builder)ewlBuilder);
    }

    default public F applyLootingBonus(NumberProvider numberProvider) {
        LootingEnchantFunction.Builder lootingEnchantBuilder = LootingEnchantFunction.m_165229_((NumberProvider)numberProvider);
        return this.addFunction((LootItemFunction.Builder)lootingEnchantBuilder);
    }

    default public F applyBinomialDistributionBonus(Enchantment enchantment, float probability, int n) {
        LootItemConditionalFunction.Builder applyBonusBuilder = ApplyBonusCount.m_79917_((Enchantment)enchantment, (float)probability, (int)n);
        return this.addFunction((LootItemFunction.Builder)applyBonusBuilder);
    }

    default public F applyOreBonus(Enchantment enchantment) {
        LootItemConditionalFunction.Builder applyBonusBuilder = ApplyBonusCount.m_79915_((Enchantment)enchantment);
        return this.addFunction((LootItemFunction.Builder)applyBonusBuilder);
    }

    default public F applyBonus(Enchantment enchantment, int multiplier) {
        LootItemConditionalFunction.Builder applyBonusBuilder = ApplyBonusCount.m_79921_((Enchantment)enchantment, (int)multiplier);
        return this.addFunction((LootItemFunction.Builder)applyBonusBuilder);
    }

    default public F simulateExplosionDecay() {
        return this.addFunction((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
    }

    default public F smeltLoot() {
        return this.addFunction((LootItemFunction.Builder)SmeltItemFunction.m_81271_());
    }

    default public F damage(NumberProvider numberProvider) {
        return this.addFunction((LootItemFunction.Builder)SetItemDamageFunction.m_165430_((NumberProvider)numberProvider));
    }

    default public F addPotion(Potion potion) {
        Objects.requireNonNull(potion);
        return this.addFunction((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)potion));
    }

    default public F addAttributes(Consumer<AddAttributesFunction.Builder> action) {
        AddAttributesFunction.Builder builder = new AddAttributesFunction.Builder();
        action.accept(builder);
        return this.addFunction(builder);
    }

    default public F limitCount(@Nullable NumberProvider numberProviderMin, @Nullable NumberProvider numberProviderMax) {
        IntRange intRange = new IntRange(numberProviderMin, numberProviderMax);
        return this.addFunction((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)intRange));
    }

    default public F limitCount(NumberProvider numberProvider) {
        return this.addFunction((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)numberProvider));
    }

    default public F addLore(Component ... components) {
        SetLoreFunction.Builder builder = SetLoreFunction.m_165443_();
        for (Component c : components) {
            builder.m_165451_(c);
        }
        return this.addFunction((LootItemFunction.Builder)builder);
    }

    default public F replaceLore(Component ... components) {
        SetLoreFunction.Builder builder = SetLoreFunction.m_165443_();
        for (Component c : components) {
            builder.m_165451_(c);
        }
        return this.addFunction((LootItemFunction.Builder)builder.m_165453_(true));
    }

    default public F setName(Component component) {
        return this.addFunction((LootItemFunction.Builder)SetNameFunction.m_165457_((Component)component));
    }

    default public F addNBT(CompoundTag tag) {
        return this.addFunction((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)tag));
    }

    default public F addNbt(CompoundTag tag) {
        return this.addFunction((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)tag));
    }

    default public F functions(ItemFilter filter, Consumer<LootFunctionsContainer<F>> action) {
        final ArrayList<LootItemFunction> functions = new ArrayList<LootItemFunction>();
        LootFunctionsContainer lfc = new LootFunctionsContainer<F>(){

            @Override
            public F addFunction(LootItemFunction lootItemFunction) {
                functions.add(lootItemFunction);
                return this;
            }

            @Override
            public F functions(ItemFilter filter, Consumer<LootFunctionsContainer<F>> action) {
                throw new UnsupportedOperationException("Nested `filteredFunctions` are not supported.");
            }
        };
        action.accept(lfc);
        return this.addFunction(new LootItemFunctionWrapperAction.CompositeLootItemFunction(functions, filter));
    }

    default public F addFunction(LootItemFunction.Builder builder) {
        return this.addFunction(builder.m_7453_());
    }

    public F addFunction(LootItemFunction var1);
}

