/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.condition;

import com.almostreliable.lootjs.loot.condition.IExtendedLootCondition;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class AnyStructure
implements IExtendedLootCondition {
    private final List<ResourceKey<ConfiguredStructureFeature<?, ?>>> structures;
    private final boolean exact;

    public AnyStructure(List<ResourceKey<ConfiguredStructureFeature<?, ?>>> structures, boolean exact) {
        this.structures = structures;
        this.exact = exact;
    }

    @Override
    public boolean test(LootContext context) {
        Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (origin != null) {
            BlockPos blockPos = new BlockPos(origin.f_82479_, origin.f_82480_, origin.f_82481_);
            StructureFeatureManager sfm = context.m_78952_().m_8595_();
            Registry registry = context.m_78952_().m_5962_().m_175515_(Registry.f_122882_);
            for (ResourceKey<ConfiguredStructureFeature<?, ?>> resourceKey : this.structures) {
                StructureStart structureAt;
                ConfiguredStructureFeature feature = (ConfiguredStructureFeature)registry.m_6246_(resourceKey);
                if (feature == null || !(structureAt = this.exact ? sfm.m_207817_(blockPos, feature) : sfm.m_207785_(blockPos, feature)).m_73603_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExact() {
        return this.exact;
    }

    public List<ResourceKey<ConfiguredStructureFeature<?, ?>>> getStructuresOld() {
        return Collections.unmodifiableList(this.structures);
    }
}

