/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.util;

import com.almostreliable.lootjs.LootJSPlatform;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class Utils {
    public static <T> String getClassNameEnding(T t) {
        String tName = t.getClass().getName();
        return tName.substring(tName.lastIndexOf(46) + 1);
    }

    public static StatePropertiesPredicate.Builder createProperties(Block block, Map<String, String> propertyMap) {
        StatePropertiesPredicate.Builder propBuilder = StatePropertiesPredicate.Builder.m_67693_();
        if (propertyMap.isEmpty()) {
            return propBuilder;
        }
        Collection properties = block.m_49966_().m_61147_();
        for (Property property : properties) {
            String o = propertyMap.remove(property.m_61708_());
            if (o == null) continue;
            Optional value = property.m_6215_(o.toString());
            if (value.isEmpty()) {
                throw new IllegalArgumentException("Property " + o + " does not exists for block " + LootJSPlatform.INSTANCE.getRegistryName(block));
            }
            propBuilder.m_67700_(property, value.get().toString());
        }
        return propBuilder;
    }

    public static String formatEntity(Entity entity) {
        return String.format("Type=%s, Id=%s, Dim=%s, x=%.2f, y=%.2f, z=%.2f", Utils.quote(LootJSPlatform.INSTANCE.getRegistryName(entity.m_6095_())), entity.m_142049_(), Utils.quote(entity.f_19853_.m_46472_().m_135782_()), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    public static String formatPosition(Vec3 position) {
        return String.format("(%.2f, %.2f, %.2f)", position.f_82479_, position.f_82480_, position.f_82481_);
    }

    public static String formatItemStack(ItemStack itemStack) {
        Object tag = "";
        ItemStack copy = itemStack.m_41777_();
        if (copy.m_41783_() != null) {
            if (copy.m_41783_().m_128441_("AttributeModifiers")) {
                copy.m_41783_().m_128359_("AttributeModifiers", "...");
            }
            tag = (String)tag + " " + copy.m_41783_();
        }
        return copy + (String)tag;
    }

    public static String quote(String s) {
        return "\"" + s + "\"";
    }

    public static String quote(@Nullable ResourceLocation rl) {
        return Utils.quote(rl == null ? "NO_LOCATION" : rl.toString());
    }

    public static String quote(String prefix, Collection<?> objects) {
        return prefix + "[" + objects.stream().map(Object::toString).map(Utils::quote).collect(Collectors.joining(",")) + "]";
    }
}

