/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import de.melanx.skyguis.SkyGUIs;
import io.github.noeppi_noeppi.libx.render.ClientTickHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class TemplateRenderer {
    private final ClientLevel clientLevel;
    private final StructureTemplate template;
    private final float maxX;
    private final float maxY;
    private final transient Map<BlockPos, BlockEntity> teCache;
    private final transient Set<BlockEntity> erroredTiles;

    public TemplateRenderer(StructureTemplate template, float maxSize) {
        this(template, maxSize, maxSize);
    }

    public TemplateRenderer(StructureTemplate template, float maxX, float maxY) {
        this.clientLevel = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        this.teCache = new HashMap<BlockPos, BlockEntity>();
        this.erroredTiles = Collections.newSetFromMap(new WeakHashMap());
        this.template = template;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public void render(PoseStack poseStack, int xPos, int yPos) {
        Vec3i size = this.template.m_163801_();
        int sizeX = size.m_123341_();
        int sizeY = size.m_123342_();
        int sizeZ = size.m_123343_();
        float diag = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = this.maxX / diag;
        float scaleY = this.maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        poseStack.m_85836_();
        poseStack.m_85837_((double)xPos, (double)yPos, 100.0);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85837_((double)(-((float)sizeX) / 2.0f), (double)(-((float)sizeY) / 2.0f), 0.0);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.m_27624_();
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-30.0f));
        rotMat.m_27646_(Vector3f.f_122223_.m_122240_(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = ClientTickHandler.ticksInGame;
        poseStack.m_85837_((double)(-offX), 0.0, (double)(-offZ));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(time));
        rotMat.m_27646_(Vector3f.f_122225_.m_122240_(-time));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
        rotMat.m_27646_(Vector3f.f_122225_.m_122240_(-45.0f));
        poseStack.m_85837_((double)offX, 0.0, (double)offZ);
        eye.m_123607_(rotMat);
        eye.m_123621_();
        this.renderElements(poseStack, this.template);
        poseStack.m_85849_();
    }

    private void renderElements(PoseStack poseStack, StructureTemplate template) {
        poseStack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85837_(0.0, 0.0, -1.0);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        this.doWorldRenderPass(poseStack, template, buffers);
        this.doTileEntityRenderPass(poseStack, template, (MultiBufferSource)buffers);
        buffers.m_109911_();
        poseStack.m_85849_();
    }

    private void doWorldRenderPass(PoseStack poseStack, StructureTemplate template, MultiBufferSource.BufferSource buffers) {
        for (StructureTemplate.Palette palette : template.f_74482_) {
            for (StructureTemplate.StructureBlockInfo blockInfo : palette.m_74652_()) {
                BlockPos pos = blockInfo.f_74675_;
                BlockState bs = blockInfo.f_74676_;
                poseStack.m_85836_();
                poseStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                this.renderForMultiblock(bs, pos, poseStack, buffers);
                poseStack.m_85849_();
            }
        }
    }

    private void renderForMultiblock(BlockState state, BlockPos pos, PoseStack poseStack, MultiBufferSource.BufferSource buffers) {
        for (RenderType layer : RenderType.m_110506_()) {
            if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)layer)) continue;
            ForgeHooksClient.setRenderType((RenderType)layer);
            VertexConsumer buffer = buffers.m_6299_(layer);
            Minecraft.m_91087_().m_91289_().renderBatched(state, pos, (BlockAndTintGetter)this.clientLevel, poseStack, buffer, false, this.clientLevel.f_46441_, (IModelData)EmptyModelData.INSTANCE);
            ForgeHooksClient.setRenderType(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTileEntityRenderPass(PoseStack poseStack, StructureTemplate template, MultiBufferSource buffers) {
        for (StructureTemplate.Palette palette : template.f_74482_) {
            for (StructureTemplate.StructureBlockInfo blockInfo : palette.m_74652_()) {
                BlockPos pos = blockInfo.f_74675_;
                BlockState state = blockInfo.f_74676_;
                BlockEntity te = null;
                if (state.m_60734_() instanceof EntityBlock) {
                    te = this.teCache.computeIfAbsent(pos.m_7949_(), p -> ((EntityBlock)state.m_60734_()).m_142194_(pos, state));
                }
                if (te == null || this.erroredTiles.contains(te)) continue;
                te.m_142339_((Level)this.clientLevel);
                te.m_155250_(state);
                poseStack.m_85836_();
                poseStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                try {
                    BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(te);
                    if (renderer == null) continue;
                    renderer.m_6922_(te, 0.0f, poseStack, buffers, 0xF000F0, OverlayTexture.f_118083_);
                }
                catch (Exception e) {
                    this.erroredTiles.add(te);
                    SkyGUIs.getInstance().logger.error("An exception occurred rendering tile entity", (Throwable)e);
                }
                finally {
                    poseStack.m_85849_();
                }
            }
        }
    }
}

